/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import org.gradle.api.internal.file.archive.ZipCopyAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.ZipCompressor;
import org.gradle.api.internal.file.copy.ZipDeflatedCompressor;
import org.gradle.api.internal.file.copy.ZipStoredCompressor;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.ZipEntryCompression;

public class Zip
extends AbstractArchiveTask {
    public static final String ZIP_EXTENSION = "zip";
    private ZipEntryCompression entryCompression = ZipEntryCompression.DEFLATED;

    public Zip() {
        this.setExtension(ZIP_EXTENSION);
    }

    protected ZipCompressor getCompressor() {
        switch (this.entryCompression) {
            case DEFLATED: {
                return ZipDeflatedCompressor.INSTANCE;
            }
            case STORED: {
                return ZipStoredCompressor.INSTANCE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown Compression type %s", new Object[]{this.entryCompression}));
    }

    protected CopyAction createCopyAction() {
        return new ZipCopyAction(this.getArchivePath(), this.getCompressor());
    }

    public ZipEntryCompression getEntryCompression() {
        return this.entryCompression;
    }

    public void setEntryCompression(ZipEntryCompression entryCompression) {
        this.entryCompression = entryCompression;
    }

    @Deprecated
    protected class ZipCopyActionImpl {
        protected ZipCopyActionImpl() {
        }
    }
}

