/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DestinationRootCopySpec;
import org.gradle.api.internal.file.copy.FileCopyAction;
import org.gradle.api.internal.file.copy.SyncCopyActionDecorator;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.internal.nativeplatform.filesystem.FileSystems;
import org.gradle.internal.reflect.Instantiator;

public class Sync
extends AbstractCopyTask {
    protected CopyAction createCopyAction() {
        File destinationDir = this.getDestinationDir();
        if (destinationDir == null) {
            throw new InvalidUserDataException("No copy destination directory has been specified, use 'into' to specify a target directory.");
        }
        return new SyncCopyActionDecorator(destinationDir, new FileCopyAction(new BaseDirFileResolver(FileSystems.getDefault(), destinationDir)));
    }

    protected CopySpecInternal createRootSpec() {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        FileResolver fileResolver = (FileResolver)this.getServices().get(FileResolver.class);
        return (CopySpecInternal)instantiator.newInstance(DestinationRootCopySpec.class, new Object[]{fileResolver, super.createRootSpec()});
    }

    public DestinationRootCopySpec getRootSpec() {
        return (DestinationRootCopySpec)super.getRootSpec();
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.getRootSpec().getDestinationDir();
    }

    public void setDestinationDir(File destinationDir) {
        this.into(destinationDir);
    }
}

