/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import org.gradle.api.Transformer;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DelegatingCopySpec;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativizedCopySpec
extends DelegatingCopySpec {
    private final CopySpecInternal parent;
    private final CopySpecInternal child;

    public RelativizedCopySpec(CopySpecInternal parent, CopySpecInternal child) {
        this.parent = parent;
        this.child = child;
    }

    @Override
    protected CopySpecInternal getDelegateCopySpec() {
        return this.child;
    }

    @Override
    public RelativePath getDestPath() {
        return this.parent.getDestPath().append(this.child.getDestPath());
    }

    @Override
    public Iterable<CopySpecInternal> getChildren() {
        return CollectionUtils.collect(super.getChildren(), (Transformer)new Transformer<CopySpecInternal, CopySpecInternal>(){

            public CopySpecInternal transform(CopySpecInternal original) {
                return new RelativizedCopySpec(RelativizedCopySpec.this.parent, original);
            }
        });
    }
}

