/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.NonExtensible;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.ChainingTransformer;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.MatchingCopyAction;
import org.gradle.api.internal.file.copy.PathNotationParser;
import org.gradle.api.internal.file.copy.RegExpNameMapper;
import org.gradle.api.internal.file.copy.RelativizedCopySpec;
import org.gradle.api.internal.file.copy.RenamingCopyAction;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonExtensible
public class DefaultCopySpec
implements CopySpecInternal {
    private final FileResolver resolver;
    private final Set<Object> sourcePaths;
    private Object destDir;
    private final PatternSet patternSet;
    private final List<CopySpecInternal> childSpecs;
    private final Instantiator instantiator;
    private final DefaultCopySpec parentSpec;
    private final List<Action<? super FileCopyDetails>> actions = new ArrayList<Action<? super FileCopyDetails>>();
    private Integer dirMode;
    private Integer fileMode;
    private Boolean caseSensitive;
    private Boolean includeEmptyDirs;
    private PathNotationParser<String> pathNotationParser;
    private DuplicatesStrategy duplicatesStrategy;

    public DefaultCopySpec(FileResolver resolver, Instantiator instantiator, DefaultCopySpec parentSpec) {
        this.parentSpec = parentSpec;
        this.resolver = resolver;
        this.instantiator = instantiator;
        this.pathNotationParser = new PathNotationParser();
        this.sourcePaths = new LinkedHashSet<Object>();
        this.childSpecs = new ArrayList<CopySpecInternal>();
        this.patternSet = new PatternSet();
        this.duplicatesStrategy = null;
    }

    public DefaultCopySpec(FileResolver resolver, Instantiator instantiator) {
        this(resolver, instantiator, null);
    }

    protected FileResolver getResolver() {
        return this.resolver;
    }

    @Override
    public CopySpec with(CopySpec ... copySpecs) {
        for (CopySpec copySpec : copySpecs) {
            CopySpecInternal copySpecInternal;
            if (copySpec instanceof CopySpecSource) {
                CopySpecSource copySpecSource = (CopySpecSource)((Object)copySpec);
                copySpecInternal = copySpecSource.getRootSpec();
            } else {
                copySpecInternal = (CopySpecInternal)copySpec;
            }
            this.childSpecs.add(new RelativizedCopySpec(this, copySpecInternal));
        }
        return this;
    }

    @Override
    public CopySpec from(Object ... sourcePaths) {
        for (Object sourcePath : sourcePaths) {
            this.sourcePaths.add(sourcePath);
        }
        return this;
    }

    @Override
    public CopySpec from(Object sourcePath, Closure c) {
        if (c == null) {
            this.from(sourcePath);
            return this;
        }
        DefaultCopySpec child = this.addChild();
        child.from(sourcePath);
        ConfigureUtil.configure(c, child);
        return child;
    }

    @Override
    public DefaultCopySpec addFirst() {
        DefaultCopySpec child = (DefaultCopySpec)this.instantiator.newInstance(DefaultCopySpec.class, new Object[]{this.resolver, this.instantiator, this});
        this.childSpecs.add(0, child);
        return child;
    }

    @Override
    public DefaultCopySpec addChild() {
        DefaultCopySpec child = (DefaultCopySpec)this.instantiator.newInstance(DefaultCopySpec.class, new Object[]{this.resolver, this.instantiator, this});
        this.childSpecs.add(child);
        return child;
    }

    public Set<Object> getSourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public FileTree getSource() {
        return this.resolver.resolveFilesAsTree(this.sourcePaths).matching(this.getPatternSet());
    }

    @Override
    public FileTree getAllSource() {
        final ImmutableList.Builder builder = ImmutableList.builder();
        this.walk((Action<? super CopySpecInternal>)new Action<CopySpecInternal>(){

            public void execute(CopySpecInternal copySpecInternal) {
                builder.add((Object)copySpecInternal.getSource());
            }
        });
        return this.resolver.compositeFileTree((List<FileTree>)builder.build());
    }

    @Override
    public DefaultCopySpec into(Object destDir) {
        this.destDir = destDir;
        return this;
    }

    @Override
    public DefaultCopySpec into(Object destPath, Closure configureClosure) {
        if (configureClosure == null) {
            this.into(destPath);
            return this;
        }
        DefaultCopySpec child = this.addChild();
        child.into(destPath);
        ConfigureUtil.configure(configureClosure, child);
        return child;
    }

    @Override
    public RelativePath getDestPath() {
        RelativePath parentPath = this.parentSpec == null ? new RelativePath(false, new String[0]) : this.parentSpec.getDestPath();
        if (this.destDir == null) {
            return parentPath;
        }
        String path = this.resolveToPath(this.destDir);
        if (path.startsWith("/") || path.startsWith(File.separator)) {
            return RelativePath.parse(false, path);
        }
        return RelativePath.parse(false, parentPath, path);
    }

    private String resolveToPath(Object destDir) {
        return this.pathNotationParser.parseNotation(destDir);
    }

    public PatternSet getPatternSet() {
        PatternSet patterns = new PatternSet();
        patterns.setCaseSensitive(this.isCaseSensitive());
        patterns.include(this.getAllIncludes());
        patterns.includeSpecs(this.getAllIncludeSpecs());
        patterns.exclude(this.getAllExcludes());
        patterns.excludeSpecs(this.getAllExcludeSpecs());
        return patterns;
    }

    @Override
    public boolean isCaseSensitive() {
        if (this.caseSensitive != null) {
            return this.caseSensitive;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.isCaseSensitive();
        }
        return true;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        if (this.includeEmptyDirs != null) {
            return this.includeEmptyDirs;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.getIncludeEmptyDirs();
        }
        return true;
    }

    @Override
    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    @Override
    public DuplicatesStrategy getDuplicatesStrategy() {
        if (this.duplicatesStrategy != null) {
            return this.duplicatesStrategy;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.getDuplicatesStrategy();
        }
        return DuplicatesStrategy.INCLUDE;
    }

    @Override
    public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
        this.duplicatesStrategy = strategy;
    }

    @Override
    public CopySpec filesMatching(String pattern, Action<? super FileCopyDetails> action) {
        Spec<RelativePath> matcher = PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), pattern);
        return this.eachFile(new MatchingCopyAction(matcher, action));
    }

    @Override
    public CopySpec filesNotMatching(String pattern, Action<? super FileCopyDetails> action) {
        Spec<RelativePath> matcher = PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), pattern);
        return this.eachFile(new MatchingCopyAction((Spec<RelativePath>)new NotSpec(matcher), action));
    }

    @Override
    public CopySpec include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public CopySpec include(Iterable<String> includes) {
        this.patternSet.include((Iterable)includes);
        return this;
    }

    @Override
    public CopySpec include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include((Spec)includeSpec);
        return this;
    }

    @Override
    public CopySpec include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public CopySpec setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes((Iterable)includes);
        return this;
    }

    public List<String> getAllIncludes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.parentSpec != null) {
            result.addAll(this.parentSpec.getAllIncludes());
        }
        result.addAll(this.getIncludes());
        return result;
    }

    public List<Spec<FileTreeElement>> getAllIncludeSpecs() {
        ArrayList<Spec<FileTreeElement>> result = new ArrayList<Spec<FileTreeElement>>();
        if (this.parentSpec != null) {
            result.addAll(this.parentSpec.getAllIncludeSpecs());
        }
        result.addAll(this.patternSet.getIncludeSpecs());
        return result;
    }

    @Override
    public CopySpec exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public CopySpec exclude(Iterable<String> excludes) {
        this.patternSet.exclude((Iterable)excludes);
        return this;
    }

    @Override
    public CopySpec exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public CopySpec exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public DefaultCopySpec setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public CopySpec rename(String sourceRegEx, String replaceWith) {
        this.actions.add(new RenamingCopyAction(new RegExpNameMapper(sourceRegEx, replaceWith)));
        return this;
    }

    @Override
    public CopySpec rename(Pattern sourceRegEx, String replaceWith) {
        this.actions.add(new RenamingCopyAction(new RegExpNameMapper(sourceRegEx, replaceWith)));
        return this;
    }

    @Override
    public CopySpec filter(final Class<? extends FilterReader> filterType) {
        this.actions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(filterType);
            }
        });
        return this;
    }

    @Override
    public CopySpec filter(final Closure closure) {
        this.actions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(closure);
            }
        });
        return this;
    }

    @Override
    public CopySpec filter(final Map<String, ?> properties, final Class<? extends FilterReader> filterType) {
        this.actions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(properties, filterType);
            }
        });
        return this;
    }

    @Override
    public CopySpec expand(final Map<String, ?> properties) {
        this.actions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.expand(properties);
            }
        });
        return this;
    }

    @Override
    public CopySpec rename(Closure closure) {
        ChainingTransformer<String> transformer = new ChainingTransformer<String>(String.class);
        transformer.add(closure);
        this.actions.add(new RenamingCopyAction(transformer));
        return this;
    }

    @Override
    public Integer getDirMode() {
        if (this.dirMode != null) {
            return this.dirMode;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.getDirMode();
        }
        return null;
    }

    @Override
    public Integer getFileMode() {
        if (this.fileMode != null) {
            return this.fileMode;
        }
        if (this.parentSpec != null) {
            return this.parentSpec.getFileMode();
        }
        return null;
    }

    @Override
    public CopyProcessingSpec setDirMode(Integer mode) {
        this.dirMode = mode;
        return this;
    }

    @Override
    public CopyProcessingSpec setFileMode(Integer mode) {
        this.fileMode = mode;
        return this;
    }

    @Override
    public CopySpec eachFile(Action<? super FileCopyDetails> action) {
        this.actions.add(action);
        return this;
    }

    @Override
    public CopySpec eachFile(Closure closure) {
        this.actions.add(new ClosureBackedAction(closure));
        return this;
    }

    public List<String> getAllExcludes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.parentSpec != null) {
            result.addAll(this.parentSpec.getAllExcludes());
        }
        result.addAll(this.getExcludes());
        return result;
    }

    public List<Spec<FileTreeElement>> getAllExcludeSpecs() {
        ArrayList<Spec<FileTreeElement>> result = new ArrayList<Spec<FileTreeElement>>();
        if (this.parentSpec != null) {
            result.addAll(this.parentSpec.getAllExcludeSpecs());
        }
        result.addAll(this.patternSet.getExcludeSpecs());
        return result;
    }

    public List<Action<? super FileCopyDetails>> getAllCopyActions() {
        if (this.parentSpec == null) {
            return this.actions;
        }
        ArrayList<Action<? super FileCopyDetails>> allActions = new ArrayList<Action<? super FileCopyDetails>>();
        allActions.addAll(this.parentSpec.getAllCopyActions());
        allActions.addAll(this.actions);
        return allActions;
    }

    @Override
    public Iterable<CopySpecInternal> getChildren() {
        return this.childSpecs;
    }

    @Override
    public void walk(Action<? super CopySpecInternal> action) {
        action.execute((Object)this);
        for (CopySpecInternal child : this.getChildren()) {
            child.walk(action);
        }
    }

    @Override
    public boolean hasSource() {
        if (!this.sourcePaths.isEmpty()) {
            return true;
        }
        for (CopySpecInternal spec : this.childSpecs) {
            if (!spec.hasSource()) continue;
            return true;
        }
        return false;
    }
}

