/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import org.gradle.api.Action;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DefaultFileCopyDetails;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;

public class CopySpecBackedCopyActionProcessingStream
implements CopyActionProcessingStream {
    private final CopySpecInternal spec;
    private final Instantiator instantiator;
    private final FileSystem fileSystem;

    public CopySpecBackedCopyActionProcessingStream(CopySpecInternal spec, Instantiator instantiator, FileSystem fileSystem) {
        this.spec = spec;
        this.instantiator = instantiator;
        this.fileSystem = fileSystem;
    }

    public void process(final CopyActionProcessingStreamAction action) {
        this.spec.walk((Action<? super CopySpecInternal>)new Action<CopySpecInternal>(){

            public void execute(final CopySpecInternal spec) {
                FileTree source = spec.getSource();
                source.visit(new FileVisitor(){

                    public void visitDir(FileVisitDetails dirDetails) {
                        this.visit(dirDetails);
                    }

                    public void visitFile(FileVisitDetails fileDetails) {
                        this.visit(fileDetails);
                    }

                    private void visit(FileVisitDetails visitDetails) {
                        DefaultFileCopyDetails details = (DefaultFileCopyDetails)CopySpecBackedCopyActionProcessingStream.this.instantiator.newInstance(DefaultFileCopyDetails.class, new Object[]{visitDetails, spec, CopySpecBackedCopyActionProcessingStream.this.fileSystem});
                        for (Action<? super FileCopyDetails> action : spec.getAllCopyActions()) {
                            action.execute((Object)details);
                            if (!details.isExcluded()) continue;
                            return;
                        }
                        action.processFile(details);
                    }
                });
            }
        });
    }
}

