/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileTreeElement;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.collections.LocalFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.RandomAccessFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryFileTree
implements MinimalFileTree,
PatternFilterableFileTree,
RandomAccessFileCollection,
LocalFileTree,
DirectoryTree {
    private static final Logger LOGGER = Logging.getLogger(DirectoryFileTree.class);
    private final File dir;
    private PatternSet patternSet;
    private boolean postfix;

    public DirectoryFileTree(File dir) {
        this(dir, new PatternSet());
    }

    public DirectoryFileTree(File dir, PatternSet patternSet) {
        this.patternSet = patternSet;
        this.dir = GFileUtils.canonicalise(dir);
    }

    @Override
    public String getDisplayName() {
        String includes = this.patternSet.getIncludes().isEmpty() ? "" : String.format(" include %s", GUtil.toString(this.patternSet.getIncludes()));
        String excludes = this.patternSet.getExcludes().isEmpty() ? "" : String.format(" exclude %s", GUtil.toString(this.patternSet.getExcludes()));
        return String.format("directory '%s'%s%s", this.dir, includes, excludes);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public PatternSet getPatterns() {
        return this.patternSet;
    }

    @Override
    public File getDir() {
        return this.dir;
    }

    @Override
    public Collection<DirectoryFileTree> getLocalContents() {
        return Collections.singletonList(this);
    }

    @Override
    public DirectoryFileTree filter(PatternFilterable patterns) {
        PatternSet patternSet = this.patternSet.intersect();
        patternSet.copyFrom(patterns);
        return new DirectoryFileTree(this.dir, patternSet);
    }

    @Override
    public boolean contains(File file) {
        String prefix = this.dir.getAbsolutePath() + File.separator;
        if (!file.getAbsolutePath().startsWith(prefix)) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        RelativePath path = new RelativePath(true, file.getAbsolutePath().substring(prefix.length()).split(Pattern.quote(File.separator)));
        return this.patternSet.getAsSpec().isSatisfiedBy((Object)new DefaultFileTreeElement(file, path));
    }

    @Override
    public void visit(FileVisitor visitor) {
        this.visitFrom(visitor, this.dir, new RelativePath(false, new String[0]));
    }

    public void visitFrom(FileVisitor visitor, File dir, RelativePath path) {
        AtomicBoolean stopFlag = new AtomicBoolean();
        Spec<FileTreeElement> spec = this.patternSet.getAsSpec();
        if (dir.exists()) {
            if (dir.isFile()) {
                this.processSingleFile(dir, visitor, spec, stopFlag);
            } else {
                this.walkDir(dir, path, visitor, spec, stopFlag);
            }
        } else {
            LOGGER.info("file or directory '" + dir + "', not found");
        }
    }

    private void processSingleFile(File file, FileVisitor visitor, Spec<FileTreeElement> spec, AtomicBoolean stopFlag) {
        RelativePath path = new RelativePath(true, file.getName());
        DefaultFileVisitDetails details = new DefaultFileVisitDetails(file, path, stopFlag);
        if (this.isAllowed(details, spec)) {
            visitor.visitFile(details);
        }
    }

    private void walkDir(File file, RelativePath path, FileVisitor visitor, Spec<FileTreeElement> spec, AtomicBoolean stopFlag) {
        int i;
        File[] children = file.listFiles();
        if (children == null) {
            if (file.isDirectory() && !file.canRead()) {
                throw new GradleException(String.format("Could not list contents of directory '%s' as it is not readable.", file));
            }
            throw new GradleException(String.format("Could not list contents of '%s'.", file));
        }
        ArrayList<DefaultFileVisitDetails> dirs = new ArrayList<DefaultFileVisitDetails>();
        for (i = 0; !stopFlag.get() && i < children.length; ++i) {
            File child = children[i];
            boolean isFile = child.isFile();
            RelativePath childPath = path.append(isFile, child.getName());
            DefaultFileVisitDetails details = new DefaultFileVisitDetails(child, childPath, stopFlag);
            if (!this.isAllowed(details, spec)) continue;
            if (isFile) {
                visitor.visitFile(details);
                continue;
            }
            dirs.add(details);
        }
        for (i = 0; !stopFlag.get() && i < dirs.size(); ++i) {
            FileVisitDetails dir = (FileVisitDetails)dirs.get(i);
            if (this.postfix) {
                this.walkDir(dir.getFile(), dir.getRelativePath(), visitor, spec, stopFlag);
                visitor.visitDir(dir);
                continue;
            }
            visitor.visitDir(dir);
            this.walkDir(dir.getFile(), dir.getRelativePath(), visitor, spec, stopFlag);
        }
    }

    boolean isAllowed(FileTreeElement element, Spec<FileTreeElement> spec) {
        return spec.isSatisfiedBy((Object)element);
    }

    public DirectoryFileTree postfix() {
        this.postfix = true;
        return this;
    }
}

