/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.internal.file.copy.ZipCompressor;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.UncheckedException;

public class ZipCopyAction
implements CopyAction {
    private final File zipFile;
    private final ZipCompressor compressor;

    public ZipCopyAction(File zipFile, ZipCompressor compressor) {
        this.zipFile = zipFile;
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkResult execute(CopyActionProcessingStream stream) {
        ZipOutputStream zipOutStr;
        try {
            zipOutStr = this.compressor.createArchiveOutputStream(this.zipFile);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not create ZIP '%s'.", this.zipFile), (Throwable)e);
        }
        try {
            stream.process(new StreamAction(zipOutStr));
        }
        catch (Exception e) {
            UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zipOutStr);
        }
        return new SimpleWorkResult(true);
    }

    private class StreamAction
    implements CopyActionProcessingStreamAction {
        private final ZipOutputStream zipOutStr;

        public StreamAction(ZipOutputStream zipOutStr) {
            this.zipOutStr = zipOutStr;
        }

        public void processFile(FileCopyDetailsInternal details) {
            if (details.isDirectory()) {
                this.visitDir(details);
            } else {
                this.visitFile(details);
            }
        }

        private void visitFile(FileCopyDetails fileDetails) {
            try {
                ZipEntry archiveEntry = new ZipEntry(fileDetails.getRelativePath().getPathString());
                archiveEntry.setTime(fileDetails.getLastModified());
                archiveEntry.setUnixMode(0x8000 | fileDetails.getMode());
                this.zipOutStr.putNextEntry(archiveEntry);
                fileDetails.copyTo((OutputStream)this.zipOutStr);
                this.zipOutStr.closeEntry();
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not add %s to ZIP '%s'.", fileDetails, ZipCopyAction.this.zipFile), (Throwable)e);
            }
        }

        private void visitDir(FileCopyDetails dirDetails) {
            try {
                ZipEntry archiveEntry = new ZipEntry(dirDetails.getRelativePath().getPathString() + '/');
                archiveEntry.setTime(dirDetails.getLastModified());
                archiveEntry.setUnixMode(0x4000 | dirDetails.getMode());
                this.zipOutStr.putNextEntry(archiveEntry);
                this.zipOutStr.closeEntry();
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not add %s to ZIP '%s'.", dirDetails, ZipCopyAction.this.zipFile), (Throwable)e);
            }
        }
    }
}

