/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.internal.Factory;
import org.gradle.listener.LazyCreationProxy;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskArtifactStateCacheAccess
implements TaskArtifactStateCacheAccess {
    private final Gradle gradle;
    private final CacheRepository cacheRepository;
    private PersistentCache cache;
    private final Object lock = new Object();

    public DefaultTaskArtifactStateCacheAccess(Gradle gradle, CacheRepository cacheRepository) {
        this.gradle = gradle;
        this.cacheRepository = cacheRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentCache getCache() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cache == null) {
                this.cache = (PersistentCache)this.cacheRepository.cache("taskArtifacts").forObject(this.gradle).withDisplayName("task artifact state cache").withLockMode(FileLockManager.LockMode.Exclusive).open();
            }
            return this.cache;
        }
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(final String cacheName, final Class<K> keyType, Class<V> valueType, final Serializer<V> valueSerializer) {
        Factory<PersistentIndexedCache> factory = new Factory<PersistentIndexedCache>(){

            public PersistentIndexedCache create() {
                return DefaultTaskArtifactStateCacheAccess.this.getCache().createCache(DefaultTaskArtifactStateCacheAccess.this.cacheFile(cacheName), keyType, valueSerializer);
            }
        };
        return new LazyCreationProxy<PersistentIndexedCache>(PersistentIndexedCache.class, factory).getSource();
    }

    private File cacheFile(String cacheName) {
        return new File(this.getCache().getBaseDir(), cacheName + ".bin");
    }

    @Override
    public <T> T useCache(String operationDisplayName, Factory<? extends T> action) {
        return this.getCache().useCache(operationDisplayName, action);
    }

    @Override
    public void useCache(String operationDisplayName, Runnable action) {
        this.getCache().useCache(operationDisplayName, action);
    }

    @Override
    public void longRunningOperation(String operationDisplayName, Runnable action) {
        this.getCache().longRunningOperation(operationDisplayName, action);
    }
}

