/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMessageLogger {
    private static final Logger LOGGER = Logging.getLogger(DeprecationLogger.class);
    private static final Set<String> DYNAMIC_PROPERTIES = Collections.synchronizedSet(new HashSet());
    private static final Set<String> MESSAGES = Collections.synchronizedSet(new HashSet());
    private static final Set<String> FEATURES = Collections.synchronizedSet(new HashSet());
    private static final ThreadLocal<Boolean> ENABLED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private static final ThreadLocal<Boolean> LOG_TRACE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    public static final String ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME = "org.gradle.deprecation.trace";
    private static String deprecationMessage;
    private static Lock deprecationMessageLock;
    public static final String INCUBATION_MESSAGE = "%s is an incubating feature.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDeprecationMessage() {
        if (deprecationMessage == null) {
            deprecationMessageLock.lock();
            try {
                if (deprecationMessage == null) {
                    String messageBase = "has been deprecated and is scheduled to be removed in";
                    GradleVersion currentVersion = GradleVersion.current();
                    int versionMajor = currentVersion.getMajor();
                    String when = versionMajor == -1 ? "the next major version of Gradle" : String.format("Gradle %d.0", versionMajor + 1);
                    deprecationMessage = String.format("%s %s", messageBase, when);
                }
            }
            finally {
                deprecationMessageLock.unlock();
            }
        }
        return deprecationMessage;
    }

    public static void reset() {
        DYNAMIC_PROPERTIES.clear();
        MESSAGES.clear();
        FEATURES.clear();
    }

    public static void nagUserOfReplacedPlugin(String pluginName, String replacement) {
        SingleMessageLogger.nagUserWith(String.format("The %s plugin %S. Please use the %s plugin instead.", pluginName, SingleMessageLogger.getDeprecationMessage(), replacement));
    }

    public static void nagUserOfReplacedTaskType(String taskName, String replacement) {
        SingleMessageLogger.nagUserWith(String.format("The %s task type %s. Please use the %s instead.", taskName, SingleMessageLogger.getDeprecationMessage(), replacement));
    }

    public static void nagUserOfReplacedMethod(String methodName, String replacement) {
        SingleMessageLogger.nagUserWith(String.format("The %s method %s. Please use the %s method instead.", methodName, SingleMessageLogger.getDeprecationMessage(), replacement));
    }

    public static void nagUserOfReplacedProperty(String propertyName, String replacement) {
        SingleMessageLogger.nagUserWith(String.format("The %s property %s. Please use the %s property instead.", propertyName, SingleMessageLogger.getDeprecationMessage(), replacement));
    }

    public static void nagUserOfDiscontinuedMethod(String methodName) {
        SingleMessageLogger.nagUserWith(String.format("The %s method %s.", methodName, SingleMessageLogger.getDeprecationMessage()));
    }

    public static void nagUserOfDiscontinuedProperty(String propertyName, String advice) {
        SingleMessageLogger.nagUserWith(String.format("The %s property %s. %s", propertyName, SingleMessageLogger.getDeprecationMessage(), advice));
    }

    public static void nagUserOfDiscontinuedConfiguration(String configurationName, String advice) {
        SingleMessageLogger.nagUserWith(String.format("The %s configuration %s. %s", configurationName, SingleMessageLogger.getDeprecationMessage(), advice));
    }

    public static void nagUserOfReplacedNamedParameter(String parameterName, String replacement) {
        SingleMessageLogger.nagUserWith(String.format("The %s named parameter %s. Please use the %s named parameter instead.", parameterName, SingleMessageLogger.getDeprecationMessage(), replacement));
    }

    public static void nagUserWith(String message) {
        if (SingleMessageLogger.isEnabled() && MESSAGES.add(message)) {
            LOGGER.warn(message);
            SingleMessageLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfDeprecated(String thing) {
        SingleMessageLogger.nagUserWith(String.format("%s %s", thing, SingleMessageLogger.getDeprecationMessage()));
    }

    public static void nagUserOfDeprecated(String thing, String explanation) {
        SingleMessageLogger.nagUserWith(String.format("%s %s. %s.", thing, SingleMessageLogger.getDeprecationMessage(), explanation));
    }

    public static void nagUserOfDeprecatedBehaviour(String behaviour) {
        SingleMessageLogger.nagUserOfDeprecated(String.format("%s. This behaviour", behaviour));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T whileDisabled(Factory<T> factory) {
        ENABLED.set(false);
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            ENABLED.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void whileDisabled(Runnable action) {
        ENABLED.set(false);
        try {
            action.run();
        }
        finally {
            ENABLED.set(true);
        }
    }

    private static boolean isTraceLoggingEnabled() {
        return Boolean.getBoolean(ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME) || LOG_TRACE.get() != false;
    }

    private static void logTraceIfNecessary() {
        if (SingleMessageLogger.isTraceLoggingEnabled()) {
            StackTraceElement[] stack;
            for (StackTraceElement frame : stack = StackTraceUtils.sanitize((Throwable)new Exception()).getStackTrace()) {
                if (frame.getClassName().startsWith(DeprecationLogger.class.getName())) continue;
                LOGGER.warn("    {}", frame.toString());
            }
        }
    }

    private static boolean isEnabled() {
        return ENABLED.get();
    }

    public static void setLogTrace(boolean flag) {
        LOG_TRACE.set(flag);
    }

    public static void nagUserAboutDynamicProperty(String propertyName, Object target, Object value) {
        if (!SingleMessageLogger.isEnabled()) {
            return;
        }
        SingleMessageLogger.nagUserOfDeprecated("Creating properties on demand (a.k.a. dynamic properties)", "Please read http://gradle.org/docs/current/dsl/org.gradle.api.plugins.ExtraPropertiesExtension.html for information on the replacement for dynamic properties");
        String propertyWithClass = target.getClass().getName() + "." + propertyName;
        if (DYNAMIC_PROPERTIES.add(propertyWithClass)) {
            String propertyWithTarget = String.format("\"%s\" on \"%s\"", propertyName, target);
            String theValue = value == null ? "null" : StringUtils.abbreviate((String)value.toString(), (int)25);
            SingleMessageLogger.nagUserWith(String.format("Deprecated dynamic property: %s, value: \"%s\".", propertyWithTarget, theValue));
        } else {
            SingleMessageLogger.nagUserWith(String.format("Deprecated dynamic property \"%s\" created in multiple locations.", propertyName));
        }
    }

    public static void incubatingFeatureUsed(String incubatingFeature) {
        if (FEATURES.add(incubatingFeature)) {
            LOGGER.lifecycle(String.format(INCUBATION_MESSAGE, incubatingFeature));
        }
    }

    static {
        deprecationMessageLock = new ReentrantLock();
    }
}

