/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.util.ClassLoaderBackedClasspathSource;
import org.gradle.util.ClasspathSource;
import org.gradle.util.JavaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiParentClassLoader
extends ClassLoader
implements ClasspathSource {
    private final List<ClassLoader> parents;
    private final JavaMethod<ClassLoader, Package[]> getPackagesMethod;
    private final JavaMethod<ClassLoader, Package> getPackageMethod;

    public MultiParentClassLoader(ClassLoader ... parents) {
        super(null);
        this.parents = new CopyOnWriteArrayList<ClassLoader>(Arrays.asList(parents));
        this.getPackagesMethod = JavaReflectionUtil.method(ClassLoader.class, Package[].class, (String)"getPackages", (Class[])new Class[0]);
        this.getPackageMethod = JavaReflectionUtil.method(ClassLoader.class, Package.class, (String)"getPackage", (Class[])new Class[]{String.class});
    }

    public void addParent(ClassLoader parent) {
        this.parents.add(parent);
    }

    @Override
    public void collectClasspath(Collection<? super URL> classpath) {
        for (ClassLoader parent : this.parents) {
            new ClassLoaderBackedClasspathSource(parent).collectClasspath(classpath);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (ClassLoader parent : this.parents) {
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(String.format("%s not found.", name));
    }

    @Override
    protected Package getPackage(String name) {
        for (ClassLoader parent : this.parents) {
            Package p = (Package)this.getPackageMethod.invoke((Object)parent, new Object[]{name});
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    protected Package[] getPackages() {
        LinkedHashSet<Package> packages = new LinkedHashSet<Package>();
        for (ClassLoader parent : this.parents) {
            Package[] parentPackages = (Package[])this.getPackagesMethod.invoke((Object)parent, new Object[0]);
            packages.addAll(Arrays.asList(parentPackages));
        }
        return packages.toArray(new Package[packages.size()]);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader parent : this.parents) {
            URL resource = parent.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        for (ClassLoader parent : this.parents) {
            Enumeration<URL> parentResources = parent.getResources(name);
            while (parentResources.hasMoreElements()) {
                resources.add(parentResources.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }
}

