/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingClassLoader
extends ClassLoader {
    private static final Object MISSING_CLASS = new Object();
    private final ConcurrentMap<String, Object> loadedClasses = new MapMaker().weakValues().makeMap();

    public CachingClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        Object cachedValue = this.loadedClasses.get(name);
        if (cachedValue instanceof Class) {
            return (Class)cachedValue;
        }
        if (cachedValue == MISSING_CLASS) {
            throw new ClassNotFoundException(name);
        }
        try {
            result = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            this.loadedClasses.putIfAbsent(name, MISSING_CLASS);
            throw e;
        }
        this.loadedClasses.putIfAbsent(name, result);
        return result;
    }
}

