/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.net.URLClassLoader;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.jvm.Jvm;
import org.gradle.util.CachingClassLoader;
import org.gradle.util.ClassLoaderFactory;
import org.gradle.util.ClasspathUtil;
import org.gradle.util.FilteringClassLoader;
import org.gradle.util.MultiParentClassLoader;
import org.gradle.util.MutableURLClassLoader;

public class DefaultClassLoaderRegistry
implements ClassLoaderRegistry {
    private final FilteringClassLoader rootClassLoader;
    private final ClassLoader coreImplClassLoader;
    private final ClassLoader pluginsClassLoader;

    public DefaultClassLoaderRegistry(ClassPathRegistry classPathRegistry, ClassLoaderFactory classLoaderFactory) {
        File toolsJar = Jvm.current().getToolsJar();
        if (toolsJar != null) {
            ClassLoader systemClassLoaderParent = ClassLoader.getSystemClassLoader().getParent();
            ClasspathUtil.addUrl((URLClassLoader)systemClassLoaderParent, new DefaultClassPath(new File[]{toolsJar}).getAsURLs());
        }
        ClassLoader runtimeClassLoader = this.getClass().getClassLoader();
        ClassPath coreImplClassPath = classPathRegistry.getClassPath("GRADLE_CORE_IMPL");
        this.coreImplClassLoader = new MutableURLClassLoader(runtimeClassLoader, coreImplClassPath);
        ClassPath pluginsClassPath = classPathRegistry.getClassPath("GRADLE_PLUGINS");
        CachingClassLoader pluginsImports = new CachingClassLoader(new MultiParentClassLoader(runtimeClassLoader, this.coreImplClassLoader));
        this.pluginsClassLoader = new MutableURLClassLoader((ClassLoader)pluginsImports, pluginsClassPath);
        this.rootClassLoader = classLoaderFactory.createFilteringClassLoader(this.pluginsClassLoader);
        this.rootClassLoader.allowPackage("org.gradle");
        this.rootClassLoader.allowResources("META-INF/gradle-plugins");
        this.rootClassLoader.allowPackage("org.apache.tools.ant");
        this.rootClassLoader.allowPackage("groovy");
        this.rootClassLoader.allowPackage("org.codehaus.groovy");
        this.rootClassLoader.allowPackage("groovyjarjarantlr");
        this.rootClassLoader.allowPackage("org.apache.ivy");
        this.rootClassLoader.allowPackage("org.slf4j");
        this.rootClassLoader.allowPackage("org.apache.commons.logging");
        this.rootClassLoader.allowPackage("org.apache.log4j");
        this.rootClassLoader.allowPackage("javax.inject");
    }

    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public ClassLoader getCoreImplClassLoader() {
        return this.coreImplClassLoader;
    }

    public ClassLoader getPluginsClassLoader() {
        return this.pluginsClassLoader;
    }
}

