/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.util.Clock;

abstract class AbstractTaskPlanExecutor
implements TaskPlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(AbstractTaskPlanExecutor.class);

    AbstractTaskPlanExecutor() {
    }

    protected Runnable taskWorker(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener) {
        return new TaskExecutorWorker(taskExecutionPlan, taskListener);
    }

    private class TaskExecutorWorker
    implements Runnable {
        private final TaskExecutionPlan taskExecutionPlan;
        private final TaskExecutionListener taskListener;
        private long busyMs;

        private TaskExecutorWorker(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener) {
            this.taskExecutionPlan = taskExecutionPlan;
            this.taskListener = taskListener;
        }

        public void run() {
            TaskInfo task;
            long start = System.currentTimeMillis();
            while ((task = this.taskExecutionPlan.getTaskToExecute()) != null) {
                this.executeTaskWithCacheLock(task);
            }
            long total = System.currentTimeMillis() - start;
            LOGGER.debug("Task worker [{}] finished, busy: {}, idle: {}", Thread.currentThread(), Clock.prettyTime(this.busyMs), Clock.prettyTime(total - this.busyMs));
        }

        private void executeTaskWithCacheLock(TaskInfo taskInfo) {
            String taskPath = taskInfo.getTask().getPath();
            LOGGER.info(taskPath + " (" + Thread.currentThread() + " - start");
            long start = System.currentTimeMillis();
            this.processTask(taskInfo);
            this.busyMs += System.currentTimeMillis() - start;
            LOGGER.info(taskPath + " (" + Thread.currentThread() + ") - complete");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processTask(TaskInfo taskInfo) {
            try {
                this.executeTask(taskInfo);
            }
            catch (Throwable e) {
                taskInfo.setExecutionFailure(e);
            }
            finally {
                this.taskExecutionPlan.taskComplete(taskInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeTask(TaskInfo taskInfo) {
            TaskInternal task = taskInfo.getTask();
            this.taskListener.beforeExecute(task);
            try {
                task.executeWithoutThrowingTaskFailure();
            }
            finally {
                this.taskListener.afterExecute(task, task.getState());
            }
        }
    }
}

