/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.initialization.ScriptClassLoaderProvider;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.configuration.ImportsReader;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.groovy.scripts.DefaultScript;
import org.gradle.groovy.scripts.ScriptAware;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.BuildScriptClasspathScriptTransformer;
import org.gradle.groovy.scripts.internal.BuildScriptTransformer;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptPluginFactory
implements ScriptPluginFactory {
    private final ScriptCompilerFactory scriptCompilerFactory;
    private final ImportsReader importsReader;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final ClassLoader defaultClassLoader;
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private final Instantiator instantiator;

    public DefaultScriptPluginFactory(ScriptCompilerFactory scriptCompilerFactory, ImportsReader importsReader, ScriptHandlerFactory scriptHandlerFactory, ClassLoader defaultClassLoader, Factory<LoggingManagerInternal> loggingManagerFactory, Instantiator instantiator) {
        this.scriptCompilerFactory = scriptCompilerFactory;
        this.importsReader = importsReader;
        this.scriptHandlerFactory = scriptHandlerFactory;
        this.defaultClassLoader = defaultClassLoader;
        this.loggingManagerFactory = loggingManagerFactory;
        this.instantiator = instantiator;
    }

    @Override
    public ScriptPlugin create(ScriptSource scriptSource) {
        return new ScriptPluginImpl(scriptSource);
    }

    static /* synthetic */ ClassLoader access$000(DefaultScriptPluginFactory x0) {
        return x0.defaultClassLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptPluginImpl
    implements ScriptPlugin {
        private final ScriptSource scriptSource;
        private String classpathClosureName = "buildscript";
        private Class<? extends BasicScript> scriptType = DefaultScript.class;
        private ScriptClassLoaderProvider classLoaderProvider;
        private ClassLoader classLoader = DefaultScriptPluginFactory.access$000(DefaultScriptPluginFactory.this);

        public ScriptPluginImpl(ScriptSource scriptSource) {
            this.scriptSource = scriptSource;
        }

        @Override
        public ScriptSource getSource() {
            return this.scriptSource;
        }

        @Override
        public ScriptPlugin setClasspathClosureName(String name) {
            this.classpathClosureName = name;
            return this;
        }

        @Override
        public ScriptPlugin setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        @Override
        public ScriptPlugin setClassLoaderProvider(ScriptClassLoaderProvider classLoaderProvider) {
            this.classLoaderProvider = classLoaderProvider;
            return this;
        }

        @Override
        public ScriptPlugin setScriptBaseClass(Class<? extends BasicScript> type) {
            this.scriptType = type;
            return this;
        }

        @Override
        public void apply(Object target) {
            DefaultServiceRegistry services = new DefaultServiceRegistry();
            services.add(ScriptPluginFactory.class, (Object)DefaultScriptPluginFactory.this);
            services.add(LoggingManagerInternal.class, DefaultScriptPluginFactory.this.loggingManagerFactory.create());
            services.add(Instantiator.class, (Object)DefaultScriptPluginFactory.this.instantiator);
            ScriptAware scriptAware = null;
            if (target instanceof ScriptAware) {
                scriptAware = (ScriptAware)target;
                scriptAware.beforeCompile(this);
            }
            ScriptClassLoaderProvider classLoaderProvider = this.classLoaderProvider;
            ScriptSource withImports = DefaultScriptPluginFactory.this.importsReader.withImports(this.scriptSource);
            if (classLoaderProvider == null) {
                ScriptHandlerInternal defaultScriptHandler = DefaultScriptPluginFactory.this.scriptHandlerFactory.create(withImports, this.classLoader);
                services.add(ScriptHandlerInternal.class, (Object)defaultScriptHandler);
                classLoaderProvider = defaultScriptHandler;
            }
            ScriptCompiler compiler = DefaultScriptPluginFactory.this.scriptCompilerFactory.createCompiler(withImports);
            compiler.setClassloader(classLoaderProvider.getClassLoader());
            BuildScriptClasspathScriptTransformer classpathScriptTransformer = new BuildScriptClasspathScriptTransformer(this.classpathClosureName);
            compiler.setTransformer(classpathScriptTransformer);
            ScriptRunner<? extends BasicScript> classPathScriptRunner = compiler.compile(this.scriptType);
            classPathScriptRunner.getScript().init(target, (ServiceRegistry)services);
            classPathScriptRunner.run();
            classLoaderProvider.updateClassPath();
            compiler.setTransformer(new BuildScriptTransformer(classpathScriptTransformer));
            ScriptRunner<? extends BasicScript> runner = compiler.compile(this.scriptType);
            runner.getScript().init(target, (ServiceRegistry)services);
            if (scriptAware != null) {
                scriptAware.afterCompile(this, runner.getScript());
            }
            runner.run();
        }
    }
}

