/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.FileLockCommunicator;
import org.gradle.cache.internal.GracefullyStoppedException;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;

public class DefaultFileLockContentionHandler
implements FileLockContentionHandler {
    private static final Logger LOGGER = Logging.getLogger(DefaultFileLockContentionHandler.class);
    private final Lock lock = new ReentrantLock();
    private final Map<Long, Runnable> contendedActions = new HashMap<Long, Runnable>();
    private final DefaultExecutorFactory executorFactory;
    private FileLockCommunicator communicator;
    private StoppableExecutor executor;
    private boolean stopped;

    public DefaultFileLockContentionHandler() {
        this(new DefaultExecutorFactory());
    }

    DefaultFileLockContentionHandler(DefaultExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    private Runnable listener() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    LOGGER.info("Starting file lock listener thread.");
                    this.doRun();
                }
                catch (Throwable t) {
                    LOGGER.error("Problems handling incoming cache access requests.", t);
                }
                finally {
                    LOGGER.info("File lock listener thread completed.");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doRun() {
                while (true) {
                    Runnable action;
                    long lockId;
                    try {
                        lockId = DefaultFileLockContentionHandler.this.communicator.receive();
                    }
                    catch (GracefullyStoppedException e) {
                        return;
                    }
                    DefaultFileLockContentionHandler.this.lock.lock();
                    try {
                        action = (Runnable)DefaultFileLockContentionHandler.this.contendedActions.get(lockId);
                        if (action == null) {
                            continue;
                        }
                    }
                    finally {
                        DefaultFileLockContentionHandler.this.lock.unlock();
                        continue;
                    }
                    action.run();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long lockId, Runnable whenContended) {
        this.lock.lock();
        try {
            this.assertNotStopped();
            if (this.communicator == null) {
                throw new IllegalStateException("Must initialize the handler by reserving the port first.");
            }
            if (this.executor == null) {
                this.executor = this.executorFactory.create("Listen for file lock access requests from other processes");
                this.executor.execute(this.listener());
            }
            this.contendedActions.put(lockId, whenContended);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void assertNotStopped() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot start managing file contention because this handler has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long lockId) {
        this.lock.lock();
        try {
            this.contendedActions.remove(lockId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            this.contendedActions.clear();
            if (this.communicator != null) {
                this.communicator.stop();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.executor != null) {
            this.executor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reservePort() {
        this.lock.lock();
        try {
            this.assertNotStopped();
            if (this.communicator == null) {
                this.communicator = new FileLockCommunicator();
            }
            int n = this.communicator.getPort();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

