/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.cacheops;

import java.util.ArrayList;
import java.util.List;
import org.gradle.cache.internal.cacheops.CacheOperation;

class CacheOperationStack {
    private final List<CacheOperation> operations = new ArrayList<CacheOperation>();

    CacheOperationStack() {
    }

    public String getDescription() {
        this.checkNotEmpty();
        return this.operations.get((int)0).description;
    }

    public CacheOperationStack pushLongRunningOperation(String description) {
        this.operations.add(0, new CacheOperation(description, true));
        return this;
    }

    public void popLongRunningOperation(String description) {
        this.pop(description, true);
    }

    public boolean isInCacheAction() {
        return !this.operations.isEmpty() && !this.operations.get((int)0).longRunningOperation;
    }

    public boolean isInLongRunningOperation() {
        return !this.operations.isEmpty() && !this.isInCacheAction();
    }

    public CacheOperationStack pushCacheAction(String description) {
        this.operations.add(0, new CacheOperation(description, false));
        return this;
    }

    public void popCacheAction(String description) {
        this.pop(description, false);
    }

    private CacheOperation pop(String description, boolean longRunningOperation) {
        this.checkNotEmpty();
        CacheOperation operation = this.operations.remove(0);
        if (operation.description.equals(description) && operation.longRunningOperation == longRunningOperation) {
            return operation;
        }
        throw new IllegalStateException("Cannot pop operation '" + description + "'. It is not at the top of the stack");
    }

    private void checkNotEmpty() {
        if (this.operations.isEmpty()) {
            throw new IllegalStateException();
        }
    }
}

