/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.internal.btree.Block;
import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;
import org.gradle.cache.internal.btree.CorruptedCacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBackedBlockStore
implements BlockStore {
    private RandomAccessFile file;
    private final File cacheFile;
    private long nextBlock;
    private BlockStore.Factory factory;

    public FileBackedBlockStore(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    public String toString() {
        return String.format("cache '%s'", this.cacheFile);
    }

    @Override
    public void open(Runnable runnable, BlockStore.Factory factory) {
        this.factory = factory;
        try {
            this.file = new RandomAccessFile(this.cacheFile, "rw");
            this.nextBlock = this.file.length();
            if (this.file.length() == 0L) {
                runnable.run();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public void clear() {
        try {
            this.file.setLength(0L);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        this.nextBlock = 0L;
    }

    @Override
    public void attach(BlockPayload block) {
        if (block.getBlock() == null) {
            block.setBlock(new BlockImpl(block));
        }
    }

    @Override
    public void remove(BlockPayload block) {
        BlockImpl blockImpl = (BlockImpl)block.getBlock();
        blockImpl.detach();
    }

    @Override
    public void flush() {
    }

    @Override
    public <T extends BlockPayload> T readFirst(Class<T> payloadType) {
        return this.read(new BlockPointer(0L), payloadType);
    }

    @Override
    public <T extends BlockPayload> T read(BlockPointer pos, Class<T> payloadType) {
        assert (!pos.isNull());
        try {
            BlockPayload payload = (BlockPayload)payloadType.cast(this.factory.create(payloadType));
            BlockImpl block = new BlockImpl(payload, pos);
            block.read();
            return (T)payload;
        }
        catch (CorruptedCacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public void write(BlockPayload block) {
        BlockImpl blockImpl = (BlockImpl)block.getBlock();
        try {
            blockImpl.write();
        }
        catch (CorruptedCacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private long alloc(long length) {
        long pos = this.nextBlock;
        this.nextBlock += length;
        return pos;
    }

    private static class Crc32OutputStream
    extends FilterOutputStream {
        private final CRC32 checksum = new CRC32();

        private Crc32OutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int b) throws IOException {
            this.checksum.update(b);
            this.out.write(b);
        }

        public void write(byte[] bytes) throws IOException {
            this.checksum.update(bytes);
            this.out.write(bytes);
        }

        public void write(byte[] bytes, int offset, int count) throws IOException {
            this.checksum.update(bytes, offset, count);
            this.out.write(bytes, offset, count);
        }
    }

    private static class Crc32InputStream
    extends FilterInputStream {
        private final CRC32 checksum = new CRC32();

        private Crc32InputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read() throws IOException {
            int b = this.in.read();
            if (b >= 0) {
                this.checksum.update(b);
            }
            return b;
        }

        public int read(byte[] bytes) throws IOException {
            int count = this.in.read(bytes);
            if (count > 0) {
                this.checksum.update(bytes, 0, count);
            }
            return count;
        }

        public int read(byte[] bytes, int offset, int max) throws IOException {
            int count = this.in.read(bytes, offset, max);
            if (count > 0) {
                this.checksum.update(bytes, offset, count);
            }
            return count;
        }
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        private final RandomAccessFile file;

        private RandomAccessFileOutputStream(RandomAccessFile file) {
            this.file = file;
        }

        public void write(int i) throws IOException {
            this.file.write(i);
        }

        public void write(byte[] bytes) throws IOException {
            this.file.write(bytes);
        }

        public void write(byte[] bytes, int offset, int length) throws IOException {
            this.file.write(bytes, offset, length);
        }
    }

    private static class RandomAccessFileInputStream
    extends InputStream {
        private final RandomAccessFile file;

        private RandomAccessFileInputStream(RandomAccessFile file) {
            this.file = file;
        }

        public int read(byte[] bytes) throws IOException {
            return this.file.read(bytes);
        }

        public int read() throws IOException {
            return this.file.read();
        }

        public int read(byte[] bytes, int offset, int length) throws IOException {
            return this.file.read(bytes, offset, length);
        }
    }

    private final class BlockImpl
    extends Block {
        private static final int HEADER_SIZE = 6;
        private static final int TAIL_SIZE = 8;
        static final int BLOCK_MARKER = 204;
        private BlockPointer pos;
        private int payloadSize;

        private BlockImpl(BlockPayload payload, BlockPointer pos) {
            this(payload);
            this.setPos(pos);
        }

        public BlockImpl(BlockPayload payload) {
            super(payload);
            this.pos = null;
            this.payloadSize = -1;
        }

        public boolean hasPos() {
            return this.pos != null;
        }

        public BlockPointer getPos() {
            if (this.pos == null) {
                this.pos = new BlockPointer(FileBackedBlockStore.this.alloc(this.getSize()));
            }
            return this.pos;
        }

        public void setPos(BlockPointer pos) {
            assert (this.pos == null && !pos.isNull());
            this.pos = pos;
        }

        public int getSize() {
            if (this.payloadSize < 0) {
                this.payloadSize = this.getPayload().getSize();
            }
            return this.payloadSize + 6 + 8;
        }

        public void setSize(int size) {
            int newPayloadSize = size - 6 - 8;
            assert (newPayloadSize >= this.payloadSize);
            this.payloadSize = newPayloadSize;
        }

        public void write() throws Exception {
            long pos = this.getPos().getPos();
            FileBackedBlockStore.this.file.seek(pos);
            Crc32OutputStream checkSumOutputStream = new Crc32OutputStream(new BufferedOutputStream(new RandomAccessFileOutputStream(FileBackedBlockStore.this.file)));
            DataOutputStream outputStream = new DataOutputStream(checkSumOutputStream);
            BlockPayload payload = this.getPayload();
            outputStream.writeByte(204);
            outputStream.writeByte(payload.getType());
            outputStream.writeInt(this.payloadSize);
            long finalSize = pos + 6L + 8L + (long)this.payloadSize;
            payload.write(outputStream);
            outputStream.writeLong(checkSumOutputStream.checksum.getValue());
            outputStream.close();
            if (FileBackedBlockStore.this.file.length() < finalSize) {
                FileBackedBlockStore.this.file.setLength(finalSize);
            }
        }

        public void read() throws Exception {
            long pos = this.getPos().getPos();
            assert (pos >= 0L);
            if (pos + 6L >= FileBackedBlockStore.this.file.length()) {
                throw this.blockCorruptedException();
            }
            FileBackedBlockStore.this.file.seek(pos);
            Crc32InputStream checkSumInputStream = new Crc32InputStream(new BufferedInputStream(new RandomAccessFileInputStream(FileBackedBlockStore.this.file)));
            DataInputStream inputStream = new DataInputStream(checkSumInputStream);
            BlockPayload payload = this.getPayload();
            byte type = inputStream.readByte();
            if (type != -52) {
                throw this.blockCorruptedException();
            }
            type = inputStream.readByte();
            if (type != (byte)payload.getType()) {
                throw this.blockCorruptedException();
            }
            this.payloadSize = inputStream.readInt();
            if (pos + 6L + 8L + (long)this.payloadSize > FileBackedBlockStore.this.file.length()) {
                throw this.blockCorruptedException();
            }
            payload.read(inputStream);
            long actualChecksum = checkSumInputStream.checksum.getValue();
            long checksum = inputStream.readLong();
            if (actualChecksum != checksum) {
                throw this.blockCorruptedException();
            }
            inputStream.close();
        }

        public RuntimeException blockCorruptedException() {
            return new CorruptedCacheException(String.format("Corrupted %s found in %s.", this, FileBackedBlockStore.this));
        }
    }
}

