/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.DefaultCacheAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.Factory;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    private final File dir;
    private final FileLockManager.LockMode lockMode;
    private final FileLockManager lockManager;
    private final String displayName;
    private DefaultCacheAccess cacheAccess;

    public DefaultPersistentDirectoryStore(File dir, String displayName, FileLockManager.LockMode lockMode, FileLockManager fileLockManager) {
        this.dir = dir;
        this.lockMode = lockMode;
        this.lockManager = fileLockManager;
        this.displayName = displayName != null ? String.format("%s (%s)", displayName, dir) : String.format("cache directory %s (%s)", dir.getName(), dir);
    }

    @Override
    public DefaultPersistentDirectoryStore open() {
        GFileUtils.mkdirs(this.dir);
        this.cacheAccess = this.createCacheAccess();
        try {
            this.cacheAccess.open(this.lockMode);
            try {
                this.init();
            }
            catch (Throwable throwable) {
                if (this.cacheAccess != null) {
                    this.cacheAccess.close();
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new CacheOpenException(String.format("Could not open %s.", this), e);
        }
        return this;
    }

    private DefaultCacheAccess createCacheAccess() {
        return new DefaultCacheAccess(this.displayName, this.getLockTarget(), this.lockManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withExclusiveLock(Action<FileLock> action) {
        if (this.cacheAccess != null && this.cacheAccess.getFileLock().getMode() == FileLockManager.LockMode.Exclusive) {
            action.execute((Object)this.getLock());
        } else {
            boolean reopen = this.cacheAccess != null;
            this.close();
            DefaultCacheAccess exclusiveAccess = this.createCacheAccess();
            exclusiveAccess.open(FileLockManager.LockMode.Exclusive);
            try {
                action.execute((Object)exclusiveAccess.getFileLock());
            }
            finally {
                exclusiveAccess.close();
            }
            if (reopen) {
                this.cacheAccess = this.createCacheAccess();
                this.cacheAccess.open(this.lockMode);
            }
        }
    }

    protected File getLockTarget() {
        return this.dir;
    }

    protected void init() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.cacheAccess != null) {
            try {
                this.cacheAccess.close();
            }
            finally {
                this.cacheAccess = null;
            }
        }
    }

    @Override
    public FileLock getLock() {
        return this.cacheAccess.getFileLock();
    }

    @Override
    public File getBaseDir() {
        return this.dir;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(File cacheFile, Class<K> keyType, Class<V> valueType) {
        return this.cacheAccess.newCache(cacheFile, keyType, valueType);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(File cacheFile, Class<K> keyType, Serializer<V> valueSerializer) {
        return this.cacheAccess.newCache(cacheFile, keyType, valueSerializer);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(File cacheFile, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return this.cacheAccess.newCache(cacheFile, keySerializer, valueSerializer);
    }

    @Override
    public <T> T useCache(String operationDisplayName, Factory<? extends T> action) {
        return this.cacheAccess.useCache(operationDisplayName, action);
    }

    @Override
    public void useCache(String operationDisplayName, Runnable action) {
        this.cacheAccess.useCache(operationDisplayName, action);
    }

    @Override
    public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
        return this.cacheAccess.longRunningOperation(operationDisplayName, action);
    }

    @Override
    public void longRunningOperation(String operationDisplayName, Runnable action) {
        this.cacheAccess.longRunningOperation(operationDisplayName, action);
    }
}

