/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheAccess;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.cache.internal.cacheops.CacheAccessOperationsStack;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.serialize.DefaultSerializer;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultCacheAccess
implements CacheAccess {
    private static final Logger LOG = Logging.getLogger(DefaultCacheAccess.class);
    private final String cacheDiplayName;
    private final File lockFile;
    private final FileLockManager lockManager;
    private final FileAccess fileAccess = new UnitOfWorkFileAccess();
    private final Set<MultiProcessSafePersistentIndexedCache<?, ?>> caches = new HashSet();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private Thread owner;
    private FileLockManager.LockMode lockMode;
    private FileLock fileLock;
    private boolean contended;
    private final CacheAccessOperationsStack operations;
    private int cacheClosedCount;

    public DefaultCacheAccess(String cacheDisplayName, File lockFile, FileLockManager lockManager) {
        this(cacheDisplayName, lockFile, lockManager, new CacheAccessOperationsStack());
    }

    public DefaultCacheAccess(String cacheDisplayName, File lockFile, FileLockManager lockManager, CacheAccessOperationsStack operations) {
        this.cacheDiplayName = cacheDisplayName;
        this.lockFile = lockFile;
        this.lockManager = lockManager;
        this.operations = operations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(FileLockManager.LockMode lockMode) {
        this.lock.lock();
        try {
            if (this.owner != null) {
                throw new IllegalStateException(String.format("Cannot open the %s, as it is already in use.", this.cacheDiplayName));
            }
            this.lockMode = lockMode;
            if (lockMode == FileLockManager.LockMode.None) {
                return;
            }
            if (this.fileLock != null) {
                throw new IllegalStateException("File lock " + this.lockFile + " is already open.");
            }
            this.fileLock = this.lockManager.lock(this.lockFile, lockMode, this.cacheDiplayName);
            this.takeOwnership(String.format("Access %s", this.cacheDiplayName));
            this.lockManager.allowContention(this.fileLock, this.whenContended());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFileLock() {
        try {
            ++this.cacheClosedCount;
            for (MultiProcessSafePersistentIndexedCache<?, ?> cache : this.caches) {
                cache.close();
            }
            this.fileLock.close();
        }
        finally {
            this.fileLock = null;
            this.contended = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            this.operations.close();
            if (this.fileLock != null) {
                this.closeFileLock();
            }
            if (this.cacheClosedCount != 1) {
                LOG.debug("Cache {} was closed {} times.", this.cacheDiplayName, this.cacheClosedCount);
            }
        }
        finally {
            this.lockMode = null;
            this.owner = null;
            this.lock.unlock();
        }
    }

    public FileLock getFileLock() {
        return this.fileLock;
    }

    @Override
    public void useCache(String operationDisplayName, Runnable action) {
        this.useCache(operationDisplayName, Factories.toFactory((Runnable)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T useCache(String operationDisplayName, Factory<? extends T> factory) {
        if (this.lockMode == FileLockManager.LockMode.Shared) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        this.takeOwnership(operationDisplayName);
        boolean wasStarted = false;
        try {
            wasStarted = this.onStartWork();
            Object object = factory.create();
            return (T)object;
        }
        finally {
            this.lock.lock();
            try {
                if (wasStarted) {
                    this.onEndWork(operationDisplayName);
                } else {
                    this.releaseOwnership(operationDisplayName);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeOwnership(String operationDisplayName) {
        this.lock.lock();
        try {
            while (this.owner != null && this.owner != Thread.currentThread()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            this.owner = Thread.currentThread();
            this.operations.pushCacheAction(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseOwnership(String operationDisplayName) {
        this.lock.lock();
        try {
            this.operations.popCacheAction(operationDisplayName);
            if (!this.operations.isInCacheAction()) {
                this.owner = null;
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
        boolean wasEnded;
        boolean isReentrant;
        this.lock.lock();
        try {
            isReentrant = this.operations.maybeReentrantLongRunningOperation(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
        if (isReentrant) {
            try {
                Object object = action.create();
                return (T)object;
            }
            finally {
                this.popLongRunningOperation(operationDisplayName);
            }
        }
        this.lock.lock();
        try {
            this.checkThreadIsOwner();
            wasEnded = this.onEndWork();
            this.parkOwner(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
        try {
            Object object = action.create();
            return (T)object;
        }
        finally {
            this.restoreOwner(operationDisplayName);
            if (wasEnded) {
                this.onStartWork();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popLongRunningOperation(String operationDisplayName) {
        this.lock.lock();
        try {
            this.operations.popLongRunningOperation(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkThreadIsOwner() {
        this.lock.lock();
        try {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException(String.format("Cannot start long running operation, as the %s has not been locked.", this.cacheDiplayName));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parkOwner(String operationDisplayName) {
        this.lock.lock();
        try {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException(String.format("Cannot start long running operation, as the %s has not been locked.", this.cacheDiplayName));
            }
            this.owner = null;
            this.condition.signalAll();
            this.operations.pushLongRunningOperation(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreOwner(String description) {
        this.lock.lock();
        try {
            while (this.owner != null) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            this.owner = Thread.currentThread();
            this.popLongRunningOperation(description);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void longRunningOperation(String operationDisplayName, Runnable action) {
        this.longRunningOperation(operationDisplayName, Factories.toFactory((Runnable)action));
    }

    public <K, V> PersistentIndexedCache<K, V> newCache(File cacheFile, Class<K> keyType, Class<V> valueType) {
        return this.newCache(cacheFile, keyType, (Serializer<V>)new DefaultSerializer(valueType.getClassLoader()));
    }

    public <K, V> PersistentIndexedCache<K, V> newCache(File cacheFile, Class<K> keyType, Serializer<V> valueSerializer) {
        return this.newCache(cacheFile, (Serializer<K>)new DefaultSerializer(keyType.getClassLoader()), valueSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> PersistentIndexedCache<K, V> newCache(final File cacheFile, final Serializer<K> keySerializer, final Serializer<V> valueSerializer) {
        Factory indexedCacheFactory = new Factory<BTreePersistentIndexedCache<K, V>>(){

            public BTreePersistentIndexedCache<K, V> create() {
                return DefaultCacheAccess.this.doCreateCache(cacheFile, keySerializer, valueSerializer);
            }
        };
        MultiProcessSafePersistentIndexedCache indexedCache = new MultiProcessSafePersistentIndexedCache(indexedCacheFactory, this.fileAccess);
        this.lock.lock();
        try {
            this.caches.add(indexedCache);
            if (this.fileLock != null) {
                indexedCache.onStartWork(this.operations.getDescription());
            }
        }
        finally {
            this.lock.unlock();
        }
        return indexedCache;
    }

    <K, V> BTreePersistentIndexedCache<K, V> doCreateCache(File cacheFile, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new BTreePersistentIndexedCache<K, V>(cacheFile, keySerializer, valueSerializer);
    }

    private boolean onStartWork() {
        if (this.fileLock != null) {
            return false;
        }
        this.fileLock = this.lockManager.lock(this.lockFile, FileLockManager.LockMode.Exclusive, this.cacheDiplayName, this.operations.getDescription());
        for (MultiProcessSafePersistentIndexedCache<?, ?> cache : this.caches) {
            cache.onStartWork(this.operations.getDescription());
        }
        this.lockManager.allowContention(this.fileLock, this.whenContended());
        return true;
    }

    private boolean onEndWork() {
        if (this.fileLock == null) {
            return false;
        }
        if (this.contended || this.fileLock.getMode() == FileLockManager.LockMode.Shared) {
            this.closeFileLock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEndWork(String operationToRelease) {
        try {
            this.onEndWork();
        }
        finally {
            this.releaseOwnership(operationToRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock getLock() {
        this.lock.lock();
        try {
            if (Thread.currentThread() != this.owner && this.owner != null || this.fileLock == null) {
                throw new IllegalStateException(String.format("The %s has not been locked for this thread. File lock: %s, owner: %s", this.cacheDiplayName, this.fileLock != null, this.owner));
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.fileLock;
    }

    Runnable whenContended() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DefaultCacheAccess.this.lock.lock();
                try {
                    LOG.debug("Detected file lock contention of {} (fileLock={}, contended={}, owner={})", DefaultCacheAccess.this.cacheDiplayName, DefaultCacheAccess.this.fileLock != null, DefaultCacheAccess.this.contended, DefaultCacheAccess.this.owner);
                    if (DefaultCacheAccess.this.fileLock == null) {
                        return;
                    }
                    if (DefaultCacheAccess.this.owner != null) {
                        DefaultCacheAccess.this.contended = true;
                        return;
                    }
                    DefaultCacheAccess.this.takeOwnership("Other process requested access to " + DefaultCacheAccess.this.cacheDiplayName);
                    try {
                        DefaultCacheAccess.this.closeFileLock();
                    }
                    finally {
                        DefaultCacheAccess.this.releaseOwnership("Other process requested access to " + DefaultCacheAccess.this.cacheDiplayName);
                    }
                }
                finally {
                    DefaultCacheAccess.this.lock.unlock();
                }
            }
        };
    }

    Thread getOwner() {
        return this.owner;
    }

    FileAccess getFileAccess() {
        return this.fileAccess;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnitOfWorkFileAccess
    extends AbstractFileAccess {
        private UnitOfWorkFileAccess() {
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException {
            return DefaultCacheAccess.this.getLock().readFile(action);
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().updateFile(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().writeFile(action);
        }
    }
}

