/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import java.io.File;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.archive.ZipCopyAction;
import org.gradle.api.internal.file.archive.ZipCopySpecVisitor;
import org.gradle.api.internal.file.copy.CopyActionImpl;
import org.gradle.api.internal.file.copy.ZipCompressor;
import org.gradle.api.internal.file.copy.ZipDeflatedCompressor;
import org.gradle.api.internal.file.copy.ZipStoredCompressor;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.ZipEntryCompression;
import org.gradle.internal.reflect.Instantiator;

public class Zip
extends AbstractArchiveTask {
    public static final String ZIP_EXTENSION = "zip";
    private ZipCopyActionImpl action;
    private ZipEntryCompression entryCompression = ZipEntryCompression.DEFLATED;

    public Zip() {
        FileResolver fileResolver = (FileResolver)this.getServices().get(FileResolver.class);
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        this.setExtension(ZIP_EXTENSION);
        this.action = (ZipCopyActionImpl)instantiator.newInstance(ZipCopyActionImpl.class, new Object[]{this, instantiator, fileResolver});
    }

    public ZipEntryCompression getEntryCompression() {
        return this.entryCompression;
    }

    public void setEntryCompression(ZipEntryCompression entryCompression) {
        this.entryCompression = entryCompression;
    }

    protected ZipCopyActionImpl getCopyAction() {
        return this.action;
    }

    protected class ZipCopyActionImpl
    extends CopyActionImpl
    implements ZipCopyAction {
        public ZipCopyActionImpl(Instantiator instantiator, FileResolver fileResolver) {
            super(instantiator, fileResolver, new ZipCopySpecVisitor());
        }

        public File getArchivePath() {
            return Zip.this.getArchivePath();
        }

        public ZipCompressor getCompressor() {
            switch (Zip.this.entryCompression) {
                case DEFLATED: {
                    return ZipDeflatedCompressor.INSTANCE;
                }
                case STORED: {
                    return ZipStoredCompressor.INSTANCE;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown Compression type %s", new Object[]{Zip.this.entryCompression}));
        }
    }
}

