/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskContainer
extends DefaultTaskCollection<Task>
implements TaskContainerInternal {
    private final ITaskFactory taskFactory;
    private final ProjectAccessListener projectAccessListener;
    private Map<String, Runnable> placeholders = new HashMap<String, Runnable>();

    public DefaultTaskContainer(ProjectInternal project, Instantiator instantiator, ITaskFactory taskFactory, ProjectAccessListener projectAccessListener) {
        super(Task.class, instantiator, project);
        this.taskFactory = taskFactory;
        this.projectAccessListener = projectAccessListener;
    }

    @Override
    public Task create(Map<String, ?> options) {
        HashMap mutableOptions = new HashMap(options);
        Object replaceStr = mutableOptions.remove("overwrite");
        boolean replace = replaceStr != null && "true".equals(replaceStr.toString());
        TaskInternal task = this.taskFactory.createTask(mutableOptions);
        String name = task.getName();
        Task existing = (Task)this.findByNameWithoutRules(name);
        if (existing != null) {
            if (replace) {
                this.remove(existing);
            } else {
                throw new InvalidUserDataException(String.format("Cannot add %s as a task with that name already exists.", task));
            }
        }
        this.add(task);
        return task;
    }

    @Override
    public Task add(Map<String, ?> options) {
        DeprecationLogger.nagUserOfReplacedMethod("TaskContainer.add()", "create()");
        return this.create(options);
    }

    @Override
    public Task create(Map<String, ?> options, Closure configureClosure) throws InvalidUserDataException {
        return this.create(options).configure(configureClosure);
    }

    @Override
    public Task add(Map<String, ?> options, Closure configureClosure) throws InvalidUserDataException {
        DeprecationLogger.nagUserOfReplacedMethod("TaskContainer.add()", "create()");
        return this.create(options, configureClosure);
    }

    @Override
    public <T extends Task> T create(String name, Class<T> type) {
        return (T)((Task)type.cast(this.create(GUtil.map("name", name, "type", type))));
    }

    @Override
    public <T extends Task> T add(String name, Class<T> type) {
        DeprecationLogger.nagUserOfReplacedMethod("TaskContainer.add()", "create()");
        return (T)this.create(name, (Class)type);
    }

    @Override
    public Task create(String name) {
        return this.create(GUtil.map("name", name));
    }

    @Override
    public Task create(String name, Action<? super Task> configureAction) throws InvalidUserDataException {
        Task task = this.create(name);
        configureAction.execute((Object)task);
        return task;
    }

    @Override
    public Task maybeCreate(String name) {
        Task task = this.findByName(name);
        if (task != null) {
            return task;
        }
        return this.create(name);
    }

    @Override
    public Task add(String name) {
        DeprecationLogger.nagUserOfReplacedMethod("TaskContainer.add()", "create()");
        return this.create(name);
    }

    @Override
    public Task replace(String name) {
        return this.create(GUtil.map("name", name, "overwrite", true));
    }

    @Override
    public Task create(String name, Closure configureClosure) {
        return this.create(name).configure(configureClosure);
    }

    @Override
    public Task add(String name, Closure configureClosure) {
        DeprecationLogger.nagUserOfReplacedMethod("TaskContainer.add()", "create()");
        return this.create(name, configureClosure);
    }

    @Override
    public <T extends Task> T create(String name, Class<T> type, Action<? super T> configuration) throws InvalidUserDataException {
        Object task = this.create(name, (Class)type);
        configuration.execute(task);
        return (T)task;
    }

    @Override
    public <T extends Task> T replace(String name, Class<T> type) {
        return (T)((Task)type.cast(this.create(GUtil.map("name", name, "type", type, "overwrite", true))));
    }

    @Override
    public Task findByPath(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!path.contains(":")) {
            return this.findByName(path);
        }
        String projectPath = StringUtils.substringBeforeLast((String)path, (String)":");
        ProjectInternal project = this.project.findProject(!GUtil.isTrue(projectPath) ? ":" : projectPath);
        if (project == null) {
            return null;
        }
        this.projectAccessListener.beforeRequestingTaskByPath(project);
        return (Task)project.getTasks().findByName(StringUtils.substringAfterLast((String)path, (String)":"));
    }

    @Override
    public Task resolveTask(Object path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!(path instanceof CharSequence)) {
            DeprecationLogger.nagUserOfDeprecated(String.format("Converting class %s to a task dependency using toString()", path.getClass().getName()), "Please use org.gradle.api.Task, java.lang.String, org.gradle.api.Buildable, org.gradle.tasks.TaskDependency or a Closure to declare your task dependencies");
        }
        return this.getByPath(path.toString());
    }

    @Override
    public Task getByPath(String path) throws UnknownTaskException {
        Task task = this.findByPath(path);
        if (task == null) {
            throw new UnknownTaskException(String.format("Task with path '%s' not found in %s.", path, this.project));
        }
        return task;
    }

    protected Object createConfigureDelegate(Closure configureClosure) {
        return new NamedDomainObjectContainerConfigureDelegate(configureClosure.getOwner(), this);
    }

    @Override
    public TaskContainerInternal configure(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.createConfigureDelegate(configureClosure));
        return this;
    }

    @Override
    public DynamicObject getTasksAsDynamicObject() {
        return this.getElementsAsDynamicObject();
    }

    @Override
    public void actualize() {
        new CachingDirectedGraphWalker<Task, Void>(new DirectedGraph<Task, Void>(){

            @Override
            public void getNodeValues(Task node, Collection<? super Void> values, Collection<? super Task> connectedNodes) {
                connectedNodes.addAll(node.getTaskDependencies().getDependencies(node));
            }
        }).add(this).findValues();
        HashSet<String> placeholderNames = new HashSet<String>(this.placeholders.keySet());
        for (String placeholder : placeholderNames) {
            this.maybeMaterializePlaceholder(placeholder);
        }
    }

    @Override
    public Task findByName(String name) {
        Task task = (Task)super.findByName(name);
        if (task != null) {
            return task;
        }
        this.maybeMaterializePlaceholder(name);
        return (Task)super.findByName(name);
    }

    private void maybeMaterializePlaceholder(String name) {
        if (this.placeholders.containsKey(name) && super.findByName(name) == null) {
            Runnable placeholderAction = this.placeholders.remove(name);
            placeholderAction.run();
        }
    }

    @Override
    public void addPlaceholderAction(String placeholderName, Runnable runnable) {
        this.placeholders.put(placeholderName, runnable);
    }
}

