/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import org.apache.tools.ant.BuildListener;
import org.gradle.api.AntBuilder;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.ClassGeneratorBackedInstantiator;
import org.gradle.api.internal.DependencyInjectingInstantiator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.artifacts.ArtifactPublicationServices;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ProjectBackedModule;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.component.DefaultSoftwareComponentContainer;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.DefaultFileOperations;
import org.gradle.api.internal.file.DefaultTemporaryFileProvider;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.initialization.DefaultScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptClassLoaderProvider;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.DefaultPluginContainer;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.project.DefaultAntBuilderFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ServiceRegistryFactory;
import org.gradle.api.internal.project.TaskInternalServiceRegistry;
import org.gradle.api.internal.project.ant.AntLoggingAdapter;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskContainerFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.configuration.project.DefaultProjectConfigurationActionContainer;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.invocation.BuildClassLoaderRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.internal.DefaultToolingModelBuilderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectInternalServiceRegistry
extends DefaultServiceRegistry
implements ServiceRegistryFactory {
    private final ProjectInternal project;

    public ProjectInternalServiceRegistry(ServiceRegistry parent, ProjectInternal project) {
        super(parent);
        this.project = project;
    }

    protected PluginRegistry createPluginRegistry(PluginRegistry parentRegistry) {
        return parentRegistry.createChild(((ScriptClassLoaderProvider)this.get(ScriptClassLoaderProvider.class)).getClassLoader(), new DependencyInjectingInstantiator(this));
    }

    protected FileResolver createFileResolver() {
        return new BaseDirFileResolver((FileSystem)this.get(FileSystem.class), this.project.getProjectDir());
    }

    protected LoggingManagerInternal createLoggingManager() {
        return (LoggingManagerInternal)this.getFactory(LoggingManagerInternal.class).create();
    }

    protected ProjectConfigurationActionContainer createProjectConfigurationActionContainer() {
        return new DefaultProjectConfigurationActionContainer();
    }

    protected DefaultFileOperations createFileOperations() {
        return new DefaultFileOperations((FileResolver)this.get(FileResolver.class), this.project.getTasks(), (TemporaryFileProvider)this.get(TemporaryFileProvider.class), (Instantiator)this.get(Instantiator.class));
    }

    protected TemporaryFileProvider createTemporaryFileProvider() {
        return new DefaultTemporaryFileProvider(new Factory<File>(){

            public File create() {
                return new File(ProjectInternalServiceRegistry.this.project.getBuildDir(), "tmp");
            }
        });
    }

    protected Factory<AntBuilder> createAntBuilderFactory() {
        return new DefaultAntBuilderFactory((BuildListener)new AntLoggingAdapter(), this.project);
    }

    protected ToolingModelBuilderRegistry createToolingModelRegistry() {
        return new DefaultToolingModelBuilderRegistry();
    }

    protected PluginContainer createPluginContainer() {
        return new DefaultPluginContainer<ProjectInternal>((PluginRegistry)this.get(PluginRegistry.class), this.project);
    }

    protected ITaskFactory createTaskFactory(ITaskFactory parentFactory) {
        return parentFactory.createChild(this.project, new ClassGeneratorBackedInstantiator((ClassGenerator)this.get(ClassGenerator.class), new DependencyInjectingInstantiator(this)));
    }

    protected Factory<TaskContainerInternal> createTaskContainerInternal() {
        return new DefaultTaskContainerFactory((Instantiator)this.get(Instantiator.class), (ITaskFactory)this.get(ITaskFactory.class), this.project, (ProjectAccessListener)this.get(ProjectAccessListener.class));
    }

    protected ArtifactPublicationServices createArtifactPublicationServices() {
        return ((DependencyResolutionServices)this.get(DependencyResolutionServices.class)).createArtifactPublicationServices();
    }

    protected RepositoryHandler createRepositoryHandler() {
        return ((DependencyResolutionServices)this.get(DependencyResolutionServices.class)).getResolveRepositoryHandler();
    }

    protected ConfigurationContainerInternal createConfigurationContainer() {
        return ((DependencyResolutionServices)this.get(DependencyResolutionServices.class)).getConfigurationContainer();
    }

    protected SoftwareComponentContainer createSoftwareComponentContainer() {
        Instantiator instantiator = (Instantiator)this.get(Instantiator.class);
        return (SoftwareComponentContainer)instantiator.newInstance(DefaultSoftwareComponentContainer.class, new Object[]{instantiator});
    }

    protected DependencyResolutionServices createDependencyResolutionServices() {
        return this.newDependencyResolutionServices();
    }

    private DependencyResolutionServices newDependencyResolutionServices() {
        return ((DependencyManagementServices)this.get(DependencyManagementServices.class)).create((FileResolver)this.get(FileResolver.class), (DependencyMetaDataProvider)this.get(DependencyMetaDataProvider.class), (ProjectFinder)this.get(ProjectFinder.class), this.project);
    }

    protected ArtifactHandler createArtifactHandler() {
        return ((DependencyResolutionServices)this.get(DependencyResolutionServices.class)).getArtifactHandler();
    }

    protected ProjectFinder createProjectFinder() {
        return new ProjectFinder(){

            public ProjectInternal getProject(String path) {
                return ProjectInternalServiceRegistry.this.project.project(path);
            }
        };
    }

    protected DependencyHandler createDependencyHandler() {
        return ((DependencyResolutionServices)this.get(DependencyResolutionServices.class)).getDependencyHandler();
    }

    protected ScriptHandlerInternal createScriptHandler() {
        DefaultScriptHandlerFactory factory = new DefaultScriptHandlerFactory((DependencyManagementServices)this.get(DependencyManagementServices.class), (FileResolver)this.get(FileResolver.class), (DependencyMetaDataProvider)this.get(DependencyMetaDataProvider.class));
        ClassLoader parentClassLoader = this.project.getParent() != null ? this.project.getParent().getBuildscript().getClassLoader() : ((BuildClassLoaderRegistry)this.get(BuildClassLoaderRegistry.class)).getScriptClassLoader();
        return factory.create(this.project.getBuildScriptSource(), parentClassLoader, this.project);
    }

    protected DependencyMetaDataProvider createDependencyMetaDataProvider() {
        return new DependencyMetaDataProvider(){

            public Module getModule() {
                return new ProjectBackedModule(ProjectInternalServiceRegistry.this.project);
            }
        };
    }

    @Override
    public ServiceRegistryFactory createFor(Object domainObject) {
        if (domainObject instanceof TaskInternal) {
            return new TaskInternalServiceRegistry(this, this.project, (TaskInternal)domainObject);
        }
        throw new UnsupportedOperationException();
    }
}

