/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopySpecVisitor;
import org.gradle.api.internal.file.copy.DelegatingCopySpecVisitor;
import org.gradle.api.internal.file.copy.FileCopyAction;
import org.gradle.util.GFileUtils;

public class SyncCopySpecVisitor
extends DelegatingCopySpecVisitor {
    private final Set<RelativePath> visited = new HashSet<RelativePath>();
    private File baseDestDir;
    private boolean didWork;

    public SyncCopySpecVisitor(CopySpecVisitor visitor) {
        super(visitor);
    }

    public void startVisit(CopyAction action) {
        this.baseDestDir = ((FileCopyAction)action).getDestinationDir();
        this.getVisitor().startVisit(action);
    }

    public void visitDir(FileCopyDetails dirDetails) {
        this.visited.add(dirDetails.getRelativePath());
        this.getVisitor().visitDir(dirDetails);
    }

    public void visitFile(FileCopyDetails fileDetails) {
        this.visited.add(fileDetails.getRelativePath());
        this.getVisitor().visitFile(fileDetails);
    }

    public void endVisit() {
        FileVisitor visitor = new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                this.maybeDelete(dirDetails, true);
            }

            public void visitFile(FileVisitDetails fileDetails) {
                this.maybeDelete(fileDetails, false);
            }

            private void maybeDelete(FileVisitDetails fileDetails, boolean isDir) {
                RelativePath path = fileDetails.getRelativePath();
                if (!SyncCopySpecVisitor.this.visited.contains(path)) {
                    if (isDir) {
                        GFileUtils.deleteDirectory(fileDetails.getFile());
                    } else {
                        GFileUtils.deleteQuietly(fileDetails.getFile());
                    }
                    SyncCopySpecVisitor.this.didWork = true;
                }
            }
        };
        DirectoryFileTree walker = new DirectoryFileTree(this.baseDestDir).postfix();
        walker.visit(visitor);
        this.visited.clear();
        this.getVisitor().endVisit();
    }

    public boolean getDidWork() {
        return this.didWork || this.getVisitor().getDidWork();
    }
}

