/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.ContentFilterable;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.copy.CopySpecVisitor;
import org.gradle.api.internal.file.copy.DelegatingCopySpecVisitor;
import org.gradle.api.internal.file.copy.ReadableCopySpec;

public class NormalizingCopySpecVisitor
extends DelegatingCopySpecVisitor {
    private ReadableCopySpec spec;
    private final Set<RelativePath> visitedDirs = new HashSet<RelativePath>();
    private final Map<RelativePath, FileCopyDetails> pendingDirs = new HashMap<RelativePath, FileCopyDetails>();

    public NormalizingCopySpecVisitor(CopySpecVisitor visitor) {
        super(visitor);
    }

    public void visitSpec(ReadableCopySpec spec) {
        this.spec = spec;
        this.getVisitor().visitSpec(spec);
    }

    public void endVisit() {
        if (this.spec.getIncludeEmptyDirs()) {
            for (RelativePath path : new ArrayList<RelativePath>(this.pendingDirs.keySet())) {
                this.maybeVisit(path);
            }
        }
        this.visitedDirs.clear();
        this.pendingDirs.clear();
        this.getVisitor().endVisit();
    }

    private void maybeVisit(RelativePath path) {
        if (path == null || path.getParent() == null || !this.visitedDirs.add(path)) {
            return;
        }
        this.maybeVisit(path.getParent());
        FileCopyDetails dir = this.pendingDirs.remove(path);
        if (dir == null) {
            dir = new FileCopyDetailsImpl(path);
        }
        this.getVisitor().visitDir(dir);
    }

    public void visitFile(FileCopyDetails fileDetails) {
        this.maybeVisit(fileDetails.getRelativePath().getParent());
        this.getVisitor().visitFile(fileDetails);
    }

    public void visitDir(FileCopyDetails dirDetails) {
        RelativePath path = dirDetails.getRelativePath();
        if (!this.visitedDirs.contains(path)) {
            this.pendingDirs.put(path, dirDetails);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileCopyDetailsImpl
    extends AbstractFileTreeElement
    implements FileCopyDetails {
        private final RelativePath path;
        private long lastModified = System.currentTimeMillis();

        private FileCopyDetailsImpl(RelativePath path) {
            this.path = path;
        }

        @Override
        public String getDisplayName() {
            return this.path.toString();
        }

        @Override
        public File getFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDirectory() {
            return !this.path.isFile();
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public long getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativePath getRelativePath() {
            return this.path;
        }

        @Override
        public void exclude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPath(String path) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRelativePath(RelativePath path) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMode(int mode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DuplicatesStrategy getDuplicatesStrategy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Class<? extends FilterReader> filterType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable filter(Closure closure) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentFilterable expand(Map<String, ?> properties) {
            throw new UnsupportedOperationException();
        }
    }
}

