/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import org.gradle.api.Action;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopySpecVisitor;
import org.gradle.api.internal.file.copy.DefaultFileCopyDetails;
import org.gradle.api.internal.file.copy.ReadableCopySpec;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopySpecVisitorDriver {
    private final Instantiator instantiator;
    private final FileSystem fileSystem;

    public CopySpecVisitorDriver(Instantiator instantiator, FileSystem fileSystem) {
        this.instantiator = instantiator;
        this.fileSystem = fileSystem;
    }

    void visit(CopyAction copyAction, Iterable<ReadableCopySpec> specs, final CopySpecVisitor visitor) {
        visitor.startVisit(copyAction);
        for (final ReadableCopySpec spec : specs) {
            visitor.visitSpec(spec);
            FileTree source = spec.getSource();
            source.visit(new FileVisitor(){

                public void visitDir(FileVisitDetails dirDetails) {
                    visitor.visitDir(new DefaultFileCopyDetails(dirDetails, spec, CopySpecVisitorDriver.this.fileSystem));
                }

                public void visitFile(FileVisitDetails fileDetails) {
                    DefaultFileCopyDetails details = (DefaultFileCopyDetails)CopySpecVisitorDriver.this.instantiator.newInstance(DefaultFileCopyDetails.class, new Object[]{fileDetails, spec, CopySpecVisitorDriver.this.fileSystem});
                    for (Action<? super FileCopyDetails> action : spec.getAllCopyActions()) {
                        action.execute((Object)details);
                        if (!details.isExcluded()) continue;
                        return;
                    }
                    visitor.visitFile(details);
                }
            });
        }
        visitor.endVisit();
    }
}

