/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.archive.ZipCopyAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.EmptyCopySpecVisitor;

public class ZipCopySpecVisitor
extends EmptyCopySpecVisitor {
    private ZipOutputStream zipOutStr;
    private File zipFile;

    public void startVisit(CopyAction action) {
        ZipCopyAction archiveAction = (ZipCopyAction)action;
        this.zipFile = archiveAction.getArchivePath();
        try {
            this.zipOutStr = archiveAction.getCompressor().createArchiveOutputStream(this.zipFile);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not create ZIP '%s'.", this.zipFile), (Throwable)e);
        }
    }

    public void endVisit() {
        try {
            this.zipOutStr.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        finally {
            this.zipOutStr = null;
        }
    }

    public void visitFile(FileCopyDetails fileDetails) {
        try {
            ZipEntry archiveEntry = new ZipEntry(fileDetails.getRelativePath().getPathString());
            archiveEntry.setTime(fileDetails.getLastModified());
            archiveEntry.setUnixMode(0x8000 | fileDetails.getMode());
            this.zipOutStr.putNextEntry(archiveEntry);
            fileDetails.copyTo((OutputStream)this.zipOutStr);
            this.zipOutStr.closeEntry();
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not add %s to ZIP '%s'.", fileDetails, this.zipFile), (Throwable)e);
        }
    }

    public void visitDir(FileCopyDetails dirDetails) {
        try {
            ZipEntry archiveEntry = new ZipEntry(dirDetails.getRelativePath().getPathString() + '/');
            archiveEntry.setTime(dirDetails.getLastModified());
            archiveEntry.setUnixMode(0x4000 | dirDetails.getMode());
            this.zipOutStr.putNextEntry(archiveEntry);
            this.zipOutStr.closeEntry();
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not add %s to ZIP '%s'.", dirDetails, this.zipFile), (Throwable)e);
        }
    }

    public boolean getDidWork() {
        return true;
    }
}

