/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.copy.ArchiveCopyAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.EmptyCopySpecVisitor;

public class TarCopySpecVisitor
extends EmptyCopySpecVisitor {
    private TarOutputStream tarOutStr;
    private File tarFile;

    public void startVisit(CopyAction action) {
        ArchiveCopyAction archiveAction = (ArchiveCopyAction)action;
        try {
            this.tarFile = archiveAction.getArchivePath();
            OutputStream outStr = archiveAction.getCompressor().createArchiveOutputStream(this.tarFile);
            this.tarOutStr = new TarOutputStream(outStr);
            this.tarOutStr.setLongFileMode(2);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not create TAR '%s'.", this.tarFile), (Throwable)e);
        }
    }

    public void endVisit() {
        try {
            this.tarOutStr.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        finally {
            this.tarOutStr = null;
        }
    }

    public void visitFile(FileCopyDetails fileDetails) {
        try {
            TarEntry archiveEntry = new TarEntry(fileDetails.getRelativePath().getPathString());
            archiveEntry.setModTime(fileDetails.getLastModified());
            archiveEntry.setSize(fileDetails.getSize());
            archiveEntry.setMode(0x8000 | fileDetails.getMode());
            this.tarOutStr.putNextEntry(archiveEntry);
            fileDetails.copyTo((OutputStream)this.tarOutStr);
            this.tarOutStr.closeEntry();
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not add %s to TAR '%s'.", fileDetails, this.tarFile), (Throwable)e);
        }
    }

    public void visitDir(FileCopyDetails dirDetails) {
        try {
            TarEntry archiveEntry = new TarEntry(dirDetails.getRelativePath().getPathString() + '/');
            archiveEntry.setModTime(dirDetails.getLastModified());
            archiveEntry.setMode(0x4000 | dirDetails.getMode());
            this.tarOutStr.putNextEntry(archiveEntry);
            this.tarOutStr.closeEntry();
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not add %s to TAR '%s'.", dirDetails, this.tarFile), (Throwable)e);
        }
    }

    public boolean getDidWork() {
        return true;
    }
}

