/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.MapMergeChangeListener;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.id.IdGenerator;
import org.gradle.messaging.serialize.LongSerializer;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;
import org.gradle.util.NoOpChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesSnapshotter
implements FileSnapshotter {
    private final FileSnapshotter snapshotter;
    private final IdGenerator<Long> idGenerator;
    private TaskArtifactStateCacheAccess cacheAccess;
    private final PersistentIndexedCache<String, Long> dirIdentiferCache;

    public OutputFilesSnapshotter(FileSnapshotter snapshotter, IdGenerator<Long> idGenerator, TaskArtifactStateCacheAccess cacheAccess) {
        this.snapshotter = snapshotter;
        this.idGenerator = idGenerator;
        this.cacheAccess = cacheAccess;
        this.dirIdentiferCache = cacheAccess.createCache("outputFileStates", String.class, Long.class, new LongSerializer());
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return new OutputFilesSnapshot(new HashMap<String, Long>(), this.snapshotter.emptySnapshot());
    }

    @Override
    public OutputFilesSnapshot snapshot(FileCollection files) {
        final HashMap<String, Long> snapshotDirIds = new HashMap<String, Long>();
        final Set<File> theFiles = files.getFiles();
        this.cacheAccess.useCache("create dir snapshots", new Runnable(){

            public void run() {
                for (File file : theFiles) {
                    Long dirId;
                    if (file.exists()) {
                        dirId = (Long)OutputFilesSnapshotter.this.dirIdentiferCache.get(file.getAbsolutePath());
                        if (dirId == null) {
                            dirId = (Long)OutputFilesSnapshotter.this.idGenerator.generateId();
                            OutputFilesSnapshotter.this.dirIdentiferCache.put(file.getAbsolutePath(), dirId);
                        }
                    } else {
                        OutputFilesSnapshotter.this.dirIdentiferCache.remove(file.getAbsolutePath());
                        dirId = null;
                    }
                    snapshotDirIds.put(file.getAbsolutePath(), dirId);
                }
            }
        });
        return new OutputFilesSnapshot(snapshotDirIds, this.snapshotter.snapshot(files));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputFilesDiff
    implements FileCollectionSnapshot.Diff {
        private final Map<String, Long> newFileIds;
        private final Map<String, Long> oldFileIds;
        private final FileCollectionSnapshot.Diff filesDiff;

        public OutputFilesDiff(Map<String, Long> newFileIds, Map<String, Long> oldFileIds, FileCollectionSnapshot.Diff filesDiff) {
            this.newFileIds = newFileIds;
            this.oldFileIds = oldFileIds;
            this.filesDiff = filesDiff;
        }

        @Override
        public FileCollectionSnapshot applyTo(FileCollectionSnapshot snapshot, ChangeListener<FileCollectionSnapshot.Merge> listener) {
            OutputFilesSnapshot other = (OutputFilesSnapshot)snapshot;
            HashMap<String, Long> dirIds = new HashMap<String, Long>(other.rootFileIds);
            DiffUtil.diff(this.newFileIds, this.oldFileIds, new MapMergeChangeListener<String, Long>(new NoOpChangeListener<FileCollectionSnapshot.Merge>(), dirIds));
            return new OutputFilesSnapshot(this.newFileIds, this.filesDiff.applyTo(other.filesSnapshot, listener));
        }

        @Override
        public FileCollectionSnapshot applyTo(FileCollectionSnapshot snapshot) {
            return this.applyTo(snapshot, new NoOpChangeListener<FileCollectionSnapshot.Merge>());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddIgnoreChangeListenerAdapter
    implements ChangeListener<String> {
        private ChangeListener<String> delegate;
        boolean wasIgnored;

        private AddIgnoreChangeListenerAdapter() {
        }

        private void withDelegate(ChangeListener<String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void added(String element) {
            this.wasIgnored = true;
        }

        @Override
        public void removed(String element) {
            this.delegate.removed(element);
            this.wasIgnored = false;
        }

        @Override
        public void changed(String element) {
            this.delegate.changed(element);
            this.wasIgnored = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OutputFilesSnapshot
    implements FileCollectionSnapshot {
        final Map<String, Long> rootFileIds;
        final FileCollectionSnapshot filesSnapshot;

        public OutputFilesSnapshot(Map<String, Long> rootFileIds, FileCollectionSnapshot filesSnapshot) {
            this.rootFileIds = rootFileIds;
            this.filesSnapshot = filesSnapshot;
        }

        @Override
        public FileCollection getFiles() {
            return this.filesSnapshot.getFiles();
        }

        @Override
        public FileCollectionSnapshot.Diff changesSince(FileCollectionSnapshot oldSnapshot) {
            OutputFilesSnapshot other = (OutputFilesSnapshot)oldSnapshot;
            return new OutputFilesDiff(this.rootFileIds, other.rootFileIds, this.filesSnapshot.changesSince(other.filesSnapshot));
        }

        @Override
        public FileCollectionSnapshot.ChangeIterator<String> iterateChangesSince(FileCollectionSnapshot oldSnapshot) {
            OutputFilesSnapshot other = (OutputFilesSnapshot)oldSnapshot;
            final FileCollectionSnapshot.ChangeIterator<String> rootFileIdIterator = this.iterateRootFileIdChanges(other);
            final FileCollectionSnapshot.ChangeIterator<String> fileIterator = this.filesSnapshot.iterateChangesSince(other.filesSnapshot);
            final AddIgnoreChangeListenerAdapter listenerAdapter = new AddIgnoreChangeListenerAdapter();
            return new FileCollectionSnapshot.ChangeIterator<String>(){

                @Override
                public boolean next(ChangeListener<String> listener) {
                    listenerAdapter.withDelegate(listener);
                    if (rootFileIdIterator.next(listener)) {
                        return true;
                    }
                    while (fileIterator.next(listenerAdapter)) {
                        if (listenerAdapter.wasIgnored) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        private FileCollectionSnapshot.ChangeIterator<String> iterateRootFileIdChanges(OutputFilesSnapshot other) {
            HashMap<String, Long> added = new HashMap<String, Long>(this.rootFileIds);
            added.keySet().removeAll(other.rootFileIds.keySet());
            final Iterator addedIterator = added.keySet().iterator();
            HashMap<String, Long> removed = new HashMap<String, Long>(other.rootFileIds);
            removed.keySet().removeAll(this.rootFileIds.keySet());
            final Iterator removedIterator = removed.keySet().iterator();
            HashSet<String> changed = new HashSet<String>();
            for (Map.Entry<String, Long> current : this.rootFileIds.entrySet()) {
                Long otherValue = other.rootFileIds.get(current.getKey());
                if (otherValue == null || otherValue.equals(current.getValue())) continue;
                changed.add(current.getKey());
            }
            final Iterator changedIterator = changed.iterator();
            return new FileCollectionSnapshot.ChangeIterator<String>(){

                @Override
                public boolean next(ChangeListener<String> listener) {
                    if (addedIterator.hasNext()) {
                        listener.added((String)addedIterator.next());
                        return true;
                    }
                    if (removedIterator.hasNext()) {
                        listener.removed((String)removedIterator.next());
                        return true;
                    }
                    if (changedIterator.hasNext()) {
                        listener.changed((String)changedIterator.next());
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

