/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotSerializer;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotter;
import org.gradle.messaging.serialize.DataStreamBackedSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutputFilesSnapshotSerializer
extends DataStreamBackedSerializer<FileCollectionSnapshot> {
    OutputFilesSnapshotSerializer() {
    }

    public FileCollectionSnapshot read(DataInput dataInput) throws Exception {
        HashMap<String, Long> rootFileIds = new HashMap<String, Long>();
        int rootFileIdsCount = dataInput.readInt();
        for (int i = 0; i < rootFileIdsCount; ++i) {
            String key = dataInput.readUTF();
            boolean notNull = dataInput.readBoolean();
            Long value = notNull ? Long.valueOf(dataInput.readLong()) : null;
            rootFileIds.put(key, value);
        }
        FileSnapshotSerializer serializer = new FileSnapshotSerializer();
        FileCollectionSnapshot snapshot = serializer.read(dataInput);
        return new OutputFilesSnapshotter.OutputFilesSnapshot(rootFileIds, snapshot);
    }

    public void write(DataOutput dataOutput, FileCollectionSnapshot currentValue) throws IOException {
        OutputFilesSnapshotter.OutputFilesSnapshot value = (OutputFilesSnapshotter.OutputFilesSnapshot)currentValue;
        int rootFileIds = value.rootFileIds.size();
        dataOutput.writeInt(rootFileIds);
        for (String key : value.rootFileIds.keySet()) {
            Long id = value.rootFileIds.get(key);
            dataOutput.writeUTF(key);
            if (id == null) {
                dataOutput.writeBoolean(false);
                continue;
            }
            dataOutput.writeBoolean(true);
            dataOutput.writeLong(id);
        }
        FileSnapshotSerializer serializer = new FileSnapshotSerializer();
        serializer.write(dataOutput, value.filesSnapshot);
    }
}

