/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotter;
import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotterSerializer;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotSerializer;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotter;
import org.gradle.messaging.serialize.DataStreamBackedSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileSnapshotSerializer
extends DataStreamBackedSerializer<FileCollectionSnapshot> {
    FileSnapshotSerializer() {
    }

    public FileCollectionSnapshot read(DataInput dataInput) throws Exception {
        byte kind = dataInput.readByte();
        if (kind == 1) {
            DefaultFileSnapshotterSerializer serializer = new DefaultFileSnapshotterSerializer();
            return serializer.read(dataInput);
        }
        if (kind == 2) {
            OutputFilesSnapshotSerializer serializer = new OutputFilesSnapshotSerializer();
            return serializer.read(dataInput);
        }
        throw new RuntimeException("Unable to read from file snapshot cache. Unexpected value found in the data stream.");
    }

    public void write(DataOutput dataOutput, FileCollectionSnapshot value) throws IOException {
        if (value instanceof DefaultFileSnapshotter.FileCollectionSnapshotImpl) {
            dataOutput.writeByte(1);
            DefaultFileSnapshotter.FileCollectionSnapshotImpl cached = (DefaultFileSnapshotter.FileCollectionSnapshotImpl)value;
            DefaultFileSnapshotterSerializer serializer = new DefaultFileSnapshotterSerializer();
            serializer.write(dataOutput, cached);
        } else if (value instanceof OutputFilesSnapshotter.OutputFilesSnapshot) {
            dataOutput.writeByte(2);
            OutputFilesSnapshotter.OutputFilesSnapshot cached = (OutputFilesSnapshotter.OutputFilesSnapshot)value;
            OutputFilesSnapshotSerializer serializer = new OutputFilesSnapshotSerializer();
            serializer.write(dataOutput, cached);
        } else {
            throw new RuntimeException("Unable to write to file snapshot cache. Unexpected type to write: " + value);
        }
    }
}

