/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotter;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.messaging.serialize.DataStreamBackedSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultFileSnapshotterSerializer
extends DataStreamBackedSerializer<FileCollectionSnapshot> {
    DefaultFileSnapshotterSerializer() {
    }

    public FileCollectionSnapshot read(DataInput dataInput) throws Exception {
        HashMap<String, DefaultFileSnapshotter.FileSnapshot> snapshots = new HashMap<String, DefaultFileSnapshotter.FileSnapshot>();
        DefaultFileSnapshotter.FileCollectionSnapshotImpl snapshot = new DefaultFileSnapshotter.FileCollectionSnapshotImpl(snapshots);
        int snapshotsCount = dataInput.readInt();
        for (int i = 0; i < snapshotsCount; ++i) {
            String key = dataInput.readUTF();
            byte fileSnapshotKind = dataInput.readByte();
            if (fileSnapshotKind == 1) {
                snapshots.put(key, new DefaultFileSnapshotter.DirSnapshot());
                continue;
            }
            if (fileSnapshotKind == 2) {
                snapshots.put(key, new DefaultFileSnapshotter.MissingFileSnapshot());
                continue;
            }
            if (fileSnapshotKind == 3) {
                byte hashSize = dataInput.readByte();
                byte[] hash = new byte[hashSize];
                dataInput.readFully(hash);
                snapshots.put(key, new DefaultFileSnapshotter.FileHashSnapshot(hash));
                continue;
            }
            throw new RuntimeException("Unable to read serialized file collection snapshot. Unrecognized value found in the data stream.");
        }
        return snapshot;
    }

    public void write(DataOutput dataOutput, FileCollectionSnapshot value) throws IOException {
        DefaultFileSnapshotter.FileCollectionSnapshotImpl cached = (DefaultFileSnapshotter.FileCollectionSnapshotImpl)value;
        dataOutput.writeInt(cached.snapshots.size());
        for (String key : cached.snapshots.keySet()) {
            dataOutput.writeUTF(key);
            DefaultFileSnapshotter.FileSnapshot fileSnapshot = cached.snapshots.get(key);
            if (fileSnapshot instanceof DefaultFileSnapshotter.DirSnapshot) {
                dataOutput.writeByte(1);
                continue;
            }
            if (fileSnapshot instanceof DefaultFileSnapshotter.MissingFileSnapshot) {
                dataOutput.writeByte(2);
                continue;
            }
            if (!(fileSnapshot instanceof DefaultFileSnapshotter.FileHashSnapshot)) continue;
            dataOutput.writeByte(3);
            byte[] hash = ((DefaultFileSnapshotter.FileHashSnapshot)fileSnapshot).hash;
            dataOutput.writeByte(hash.length);
            dataOutput.write(hash);
        }
    }
}

