/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.Factory;
import org.gradle.messaging.serialize.DataStreamBackedSerializer;
import org.gradle.messaging.serialize.DefaultSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private final TaskArtifactStateCacheAccess cacheAccess;
    private final FileSnapshotRepository snapshotRepository;
    private final PersistentIndexedCache<String, TaskHistory> taskHistoryCache;
    private final TaskHistorySerializer serializer = new TaskHistorySerializer();

    public CacheBackedTaskHistoryRepository(TaskArtifactStateCacheAccess cacheAccess, FileSnapshotRepository snapshotRepository) {
        this.cacheAccess = cacheAccess;
        this.snapshotRepository = snapshotRepository;
        this.taskHistoryCache = cacheAccess.createCache("taskArtifacts", String.class, TaskHistory.class, this.serializer);
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal task) {
        final TaskHistory history = this.loadHistory(task);
        final LazyTaskExecution currentExecution = new LazyTaskExecution();
        currentExecution.snapshotRepository = this.snapshotRepository;
        currentExecution.cacheAccess = this.cacheAccess;
        currentExecution.setOutputFiles(CacheBackedTaskHistoryRepository.outputFiles(task));
        final LazyTaskExecution previousExecution = this.findPreviousExecution(currentExecution, history);
        if (previousExecution != null) {
            previousExecution.snapshotRepository = this.snapshotRepository;
            previousExecution.cacheAccess = this.cacheAccess;
        }
        history.configurations.add(0, currentExecution);
        return new TaskHistoryRepository.History(){

            public TaskExecution getPreviousExecution() {
                return previousExecution;
            }

            public TaskExecution getCurrentExecution() {
                return currentExecution;
            }

            public void update() {
                CacheBackedTaskHistoryRepository.this.cacheAccess.useCache("Update task history", new Runnable(){

                    public void run() {
                        if (currentExecution.inputFilesSnapshotId == null && currentExecution.inputFilesSnapshot != null) {
                            currentExecution.inputFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(currentExecution.inputFilesSnapshot);
                        }
                        if (currentExecution.outputFilesSnapshotId == null && currentExecution.outputFilesSnapshot != null) {
                            currentExecution.outputFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(currentExecution.outputFilesSnapshot);
                        }
                        while (history.configurations.size() > 3) {
                            LazyTaskExecution execution = (LazyTaskExecution)history.configurations.remove(history.configurations.size() - 1);
                            if (execution.inputFilesSnapshotId != null) {
                                CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(execution.inputFilesSnapshotId);
                            }
                            if (execution.outputFilesSnapshotId == null) continue;
                            CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(execution.outputFilesSnapshotId);
                        }
                        CacheBackedTaskHistoryRepository.this.taskHistoryCache.put(task.getPath(), history);
                    }
                });
            }
        };
    }

    private TaskHistory loadHistory(final TaskInternal task) {
        return this.cacheAccess.useCache("Load task history", new Factory<TaskHistory>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TaskHistory create() {
                ClassLoader original = CacheBackedTaskHistoryRepository.this.serializer.getClassLoader();
                CacheBackedTaskHistoryRepository.this.serializer.setClassLoader(task.getClass().getClassLoader());
                try {
                    TaskHistory history = (TaskHistory)CacheBackedTaskHistoryRepository.this.taskHistoryCache.get(task.getPath());
                    TaskHistory taskHistory = history == null ? new TaskHistory() : history;
                    return taskHistory;
                }
                finally {
                    CacheBackedTaskHistoryRepository.this.serializer.setClassLoader(original);
                }
            }
        });
    }

    private static Set<String> outputFiles(TaskInternal task) {
        HashSet<String> outputFiles = new HashSet<String>();
        for (File file : task.getOutputs().getFiles()) {
            outputFiles.add(file.getAbsolutePath());
        }
        return outputFiles;
    }

    private LazyTaskExecution findPreviousExecution(TaskExecution currentExecution, TaskHistory history) {
        Set<String> outputFiles = currentExecution.getOutputFiles();
        LazyTaskExecution bestMatch = null;
        int bestMatchOverlap = 0;
        for (LazyTaskExecution configuration : history.configurations) {
            if (outputFiles.size() == 0 && configuration.getOutputFiles().size() == 0) {
                bestMatch = configuration;
                break;
            }
            HashSet<String> intersection = new HashSet<String>(outputFiles);
            intersection.retainAll(configuration.getOutputFiles());
            if (intersection.size() > bestMatchOverlap) {
                bestMatch = configuration;
                bestMatchOverlap = intersection.size();
            }
            if (bestMatchOverlap != outputFiles.size()) continue;
            break;
        }
        return bestMatch;
    }

    private static class LazyTaskExecution
    extends TaskExecution {
        private Long inputFilesSnapshotId;
        private Long outputFilesSnapshotId;
        private transient FileSnapshotRepository snapshotRepository;
        private transient FileCollectionSnapshot inputFilesSnapshot;
        private transient FileCollectionSnapshot outputFilesSnapshot;
        private transient TaskArtifactStateCacheAccess cacheAccess;

        private LazyTaskExecution() {
        }

        public FileCollectionSnapshot getInputFilesSnapshot() {
            if (this.inputFilesSnapshot == null) {
                this.inputFilesSnapshot = this.cacheAccess.useCache("fetch input files", new Factory<FileCollectionSnapshot>(){

                    public FileCollectionSnapshot create() {
                        return LazyTaskExecution.this.snapshotRepository.get(LazyTaskExecution.this.inputFilesSnapshotId);
                    }
                });
            }
            return this.inputFilesSnapshot;
        }

        public void setInputFilesSnapshot(FileCollectionSnapshot inputFilesSnapshot) {
            this.inputFilesSnapshot = inputFilesSnapshot;
            this.inputFilesSnapshotId = null;
        }

        public FileCollectionSnapshot getOutputFilesSnapshot() {
            if (this.outputFilesSnapshot == null) {
                this.outputFilesSnapshot = this.cacheAccess.useCache("fetch output files", new Factory<FileCollectionSnapshot>(){

                    public FileCollectionSnapshot create() {
                        return LazyTaskExecution.this.snapshotRepository.get(LazyTaskExecution.this.outputFilesSnapshotId);
                    }
                });
            }
            return this.outputFilesSnapshot;
        }

        public void setOutputFilesSnapshot(FileCollectionSnapshot outputFilesSnapshot) {
            this.outputFilesSnapshot = outputFilesSnapshot;
            this.outputFilesSnapshotId = null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Serializer
        extends DataStreamBackedSerializer<LazyTaskExecution> {
            private ClassLoader classLoader;

            public Serializer(ClassLoader classLoader) {
                this.classLoader = classLoader;
            }

            public LazyTaskExecution read(DataInput dataInput) throws Exception {
                LazyTaskExecution execution = new LazyTaskExecution();
                execution.inputFilesSnapshotId = dataInput.readLong();
                execution.outputFilesSnapshotId = dataInput.readLong();
                execution.setTaskClass(dataInput.readUTF());
                int outputFiles = dataInput.readInt();
                HashSet<String> files = new HashSet<String>();
                for (int j = 0; j < outputFiles; ++j) {
                    files.add(dataInput.readUTF());
                }
                execution.setOutputFiles(files);
                int inputProperties = dataInput.readInt();
                if (inputProperties > 0) {
                    byte[] serializedMap = new byte[inputProperties];
                    dataInput.readFully(serializedMap);
                    DefaultSerializer defaultSerializer = new DefaultSerializer(this.classLoader);
                    Map map = (Map)defaultSerializer.read((InputStream)new ByteArrayInputStream(serializedMap));
                    execution.setInputProperties(map);
                } else {
                    execution.setInputProperties(new HashMap<String, Object>());
                }
                return execution;
            }

            public void write(DataOutput dataOutput, LazyTaskExecution execution) throws IOException {
                dataOutput.writeLong(execution.inputFilesSnapshotId);
                dataOutput.writeLong(execution.outputFilesSnapshotId);
                dataOutput.writeUTF(execution.getTaskClass());
                dataOutput.writeInt(execution.getOutputFiles().size());
                for (String outputFile : execution.getOutputFiles()) {
                    dataOutput.writeUTF(outputFile);
                }
                if (execution.getInputProperties() == null) {
                    dataOutput.writeInt(0);
                } else {
                    DefaultSerializer defaultSerializer = new DefaultSerializer(this.classLoader);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    defaultSerializer.write((OutputStream)outputStream, execution.getInputProperties());
                    byte[] serializedMap = outputStream.toByteArray();
                    dataOutput.writeInt(serializedMap.length);
                    dataOutput.write(serializedMap);
                }
            }
        }
    }

    private static class TaskHistory {
        private static final int MAX_HISTORY_ENTRIES = 3;
        private final List<LazyTaskExecution> configurations = new ArrayList<LazyTaskExecution>();

        private TaskHistory() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskHistorySerializer
    extends DataStreamBackedSerializer<TaskHistory> {
        private ClassLoader classLoader;

        private TaskHistorySerializer() {
        }

        public TaskHistory read(DataInput dataInput) throws Exception {
            int executions = dataInput.readByte();
            TaskHistory history = new TaskHistory();
            LazyTaskExecution.Serializer executionSerializer = new LazyTaskExecution.Serializer(this.classLoader);
            for (int i = 0; i < executions; ++i) {
                LazyTaskExecution exec = executionSerializer.read(dataInput);
                history.configurations.add(exec);
            }
            return history;
        }

        public void write(DataOutput dataOutput, TaskHistory value) throws IOException {
            int size = value.configurations.size();
            dataOutput.writeByte(size);
            LazyTaskExecution.Serializer executionSerializer = new LazyTaskExecution.Serializer(this.classLoader);
            for (LazyTaskExecution execution : value.configurations) {
                executionSerializer.write(dataOutput, execution);
            }
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }
}

