/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.ChangesOnlyIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskUpToDateState;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.reflect.Instantiator;

public class DefaultTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final TaskHistoryRepository taskHistoryRepository;
    private final FileSnapshotter outputFilesSnapshotter;
    private final FileSnapshotter inputFilesSnapshotter;
    private final Instantiator instantiator;

    public DefaultTaskArtifactStateRepository(TaskHistoryRepository taskHistoryRepository, Instantiator instantiator, FileSnapshotter outputFilesSnapshotter, FileSnapshotter inputFilesSnapshotter) {
        this.taskHistoryRepository = taskHistoryRepository;
        this.instantiator = instantiator;
        this.outputFilesSnapshotter = outputFilesSnapshotter;
        this.inputFilesSnapshotter = inputFilesSnapshotter;
    }

    public TaskArtifactState getStateFor(TaskInternal task) {
        return new TaskArtifactStateImpl(task, this.taskHistoryRepository.getHistory(task));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskArtifactStateImpl
    implements TaskArtifactState,
    TaskExecutionHistory {
        private final TaskInternal task;
        private final TaskHistoryRepository.History history;
        private boolean upToDate;
        private TaskUpToDateState states;

        public TaskArtifactStateImpl(TaskInternal task, TaskHistoryRepository.History history) {
            this.task = task;
            this.history = history;
        }

        @Override
        public boolean isUpToDate(Collection<String> messages) {
            List<String> reasons = this.getChangeMessages(this.getStates().getAllTaskChanges());
            messages.addAll(reasons);
            if (reasons.isEmpty()) {
                this.upToDate = true;
                return true;
            }
            return false;
        }

        private List<String> getChangeMessages(TaskStateChanges stateChanges) {
            ArrayList<String> messages = new ArrayList<String>();
            for (TaskStateChange stateChange : stateChanges) {
                messages.add(stateChange.getMessage());
            }
            return messages;
        }

        @Override
        public IncrementalTaskInputs getInputChanges() {
            assert (!this.upToDate) : "Should not be here if the task is up-to-date";
            if (this.canPerformIncrementalBuild()) {
                return (IncrementalTaskInputs)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(ChangesOnlyIncrementalTaskInputs.class, new Object[]{this.getStates().getInputFilesChanges()});
            }
            return (IncrementalTaskInputs)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{this.task});
        }

        private boolean canPerformIncrementalBuild() {
            List<String> messages = this.getChangeMessages(this.getStates().getRebuildChanges());
            return messages.isEmpty();
        }

        @Override
        public FileCollection getOutputFiles() {
            TaskExecution lastExecution = this.history.getPreviousExecution();
            return lastExecution != null && lastExecution.getOutputFilesSnapshot() != null ? lastExecution.getOutputFilesSnapshot().getFiles() : new SimpleFileCollection(new File[0]);
        }

        @Override
        public TaskExecutionHistory getExecutionHistory() {
            return this;
        }

        @Override
        public void beforeTask() {
        }

        @Override
        public void afterTask() {
            if (this.upToDate) {
                return;
            }
            this.getStates().getAllTaskChanges().snapshotAfterTask();
            this.history.update();
        }

        @Override
        public void finished() {
        }

        private TaskUpToDateState getStates() {
            if (this.states == null) {
                this.states = new TaskUpToDateState(this.task, this.history, DefaultTaskArtifactStateRepository.this.outputFilesSnapshotter, DefaultTaskArtifactStateRepository.this.inputFilesSnapshotter);
            }
            return this.states;
        }
    }
}

