/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Checksum;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.tools.ant.util.FileUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.UncheckedException;
import org.gradle.util.internal.LimitedDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFileUtils {
    public static FileInputStream openInputStream(File file) {
        try {
            return org.apache.commons.io.FileUtils.openInputStream((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void touch(File file) {
        try {
            org.apache.commons.io.FileUtils.touch((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void moveFile(File source, File destination) {
        try {
            org.apache.commons.io.FileUtils.moveFile((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void copyFile(File source, File destination) {
        try {
            org.apache.commons.io.FileUtils.copyFile((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void moveDirectory(File source, File destination) {
        try {
            org.apache.commons.io.FileUtils.moveDirectory((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static String readFile(File file) {
        return GFileUtils.readFile(file, Charset.defaultCharset().name());
    }

    public static String readFile(File file, String encoding) {
        try {
            return org.apache.commons.io.FileUtils.readFileToString((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void writeFile(String content, File destination) {
        GFileUtils.writeFile(content, destination, Charset.defaultCharset().name());
    }

    public static void writeFile(String content, File destination, String encoding) {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)destination, (String)content, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static Collection listFiles(File directory, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        return org.apache.commons.io.FileUtils.listFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
    }

    public static Collection listFiles(File directory, String[] extensions, boolean recursive) {
        return org.apache.commons.io.FileUtils.listFiles((File)directory, (String[])extensions, (boolean)recursive);
    }

    public static List<String> toPaths(Collection<File> files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        return paths;
    }

    public static List<URL> urisToUrls(Iterable<URI> uris) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URI uri : uris) {
            try {
                urls.add(uri.toURL());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        return urls;
    }

    public static void copyURLToFile(URL source, File destination) {
        try {
            org.apache.commons.io.FileUtils.copyURLToFile((URL)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void deleteDirectory(File directory) {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void cleanDirectory(File directory) {
        try {
            org.apache.commons.io.FileUtils.cleanDirectory((File)directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static boolean deleteQuietly(File file) {
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    public static String tail(File file, int maxLines) throws TailReadingException {
        String string;
        BufferedReader reader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            LimitedDescription description = new LimitedDescription(maxLines);
            String line = reader.readLine();
            while (line != null) {
                description.append(line);
                line = reader.readLine();
            }
            string = description.toString();
        }
        catch (Exception e) {
            try {
                throw new TailReadingException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    public static void writeStringToFile(File file, String data) {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)data);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void forceDelete(File file) {
        try {
            org.apache.commons.io.FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static Checksum checksum(File file, Checksum checksum) {
        try {
            return org.apache.commons.io.FileUtils.checksum((File)file, (Checksum)checksum);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static File canonicalise(File src) {
        try {
            return src.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static String relativePath(File from, File to) {
        try {
            return FileUtils.getRelativePath((File)from, (File)to);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static File parentMkdirs(File child) {
        File parent = child.getParentFile();
        GFileUtils.mkdirs(parent);
        return parent;
    }

    public static void mkdirs(File dir) {
        if ((dir = dir.getAbsoluteFile()).isDirectory()) {
            return;
        }
        if (dir.exists() && !dir.isDirectory()) {
            throw new UncheckedIOException(String.format("Cannot create directory '%s' as it already exists, but is not a directory", dir));
        }
        LinkedList<File> toCreate = new LinkedList<File>();
        File parent = dir.getParentFile();
        while (!parent.exists()) {
            toCreate.add(parent);
            parent = parent.getParentFile();
        }
        Collections.reverse(toCreate);
        for (File parentDirToCreate : toCreate) {
            if (parentDirToCreate.isDirectory()) continue;
            File parentDirToCreateParent = parentDirToCreate.getParentFile();
            if (!parentDirToCreateParent.isDirectory()) {
                throw new UncheckedIOException(String.format("Cannot create parent directory '%s' when creating directory '%s' as '%s' is not a directory", parentDirToCreate, dir, parentDirToCreateParent));
            }
            if (parentDirToCreate.mkdir() || parentDirToCreate.isDirectory()) continue;
            throw new UncheckedIOException(String.format("Failed to create parent directory '%s' when creating directory '%s'", parentDirToCreate, dir));
        }
        if (!dir.mkdir() && !dir.isDirectory()) {
            throw new UncheckedIOException(String.format("Failed to create directory '%s'", dir));
        }
    }

    public static class TailReadingException
    extends RuntimeException {
        public TailReadingException(Throwable throwable) {
            super(throwable);
        }
    }
}

