/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.util.HashMap;
import java.util.List;
import org.gradle.profile.CompositeOperation;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.Operation;
import org.gradle.profile.TaskExecution;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectProfile
extends Operation {
    private HashMap<String, TaskExecution> tasks = new HashMap();
    private final ContinuousOperation configurationOperation;
    private String projectPath;

    public ProjectProfile(String projectPath) {
        this.projectPath = projectPath;
        this.configurationOperation = new ContinuousOperation(projectPath);
    }

    public TaskExecution getTaskProfile(String taskPath) {
        TaskExecution result = this.tasks.get(taskPath);
        if (result == null) {
            result = new TaskExecution(taskPath);
            this.tasks.put(taskPath, result);
        }
        return result;
    }

    public CompositeOperation<TaskExecution> getTasks() {
        List taskExecutions = CollectionUtils.sort(this.tasks.values(), Operation.comparator());
        return new CompositeOperation<TaskExecution>(taskExecutions);
    }

    public String getPath() {
        return this.projectPath;
    }

    public ContinuousOperation getConfigurationOperation() {
        return this.configurationOperation;
    }

    public String toString() {
        return this.projectPath;
    }

    @Override
    public String getDescription() {
        return this.projectPath;
    }

    @Override
    long getElapsedTime() {
        return this.getTasks().getElapsedTime();
    }
}

