/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.internal.TimeProvider;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.ProfileListener;
import org.gradle.profile.ProjectProfile;
import org.gradle.profile.TaskExecution;

public class ProfileEventAdapter
implements BuildListener,
ProjectEvaluationListener,
TaskExecutionListener,
DependencyResolutionListener {
    private final BuildRequestMetaData buildMetaData;
    private final TimeProvider timeProvider;
    private final ProfileListener listener;
    private BuildProfile buildProfile;

    public ProfileEventAdapter(BuildRequestMetaData buildMetaData, TimeProvider timeProvider, ProfileListener listener) {
        this.buildMetaData = buildMetaData;
        this.timeProvider = timeProvider;
        this.listener = listener;
    }

    public void buildStarted(Gradle gradle) {
        this.buildProfile = new BuildProfile(gradle.getStartParameter());
        this.buildProfile.setBuildStarted(this.timeProvider.getCurrentTime());
        this.buildProfile.setProfilingStarted(this.buildMetaData.getBuildTimeClock().getStartTime());
    }

    public void settingsEvaluated(Settings settings) {
        this.buildProfile.setSettingsEvaluated(this.timeProvider.getCurrentTime());
    }

    public void projectsLoaded(Gradle gradle) {
        this.buildProfile.setProjectsLoaded(this.timeProvider.getCurrentTime());
    }

    public void projectsEvaluated(Gradle gradle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(BuildResult result) {
        this.buildProfile.setBuildFinished(this.timeProvider.getCurrentTime());
        this.buildProfile.setSuccessful(result.getFailure() == null);
        try {
            this.listener.buildFinished(this.buildProfile);
        }
        finally {
            this.buildProfile = null;
        }
    }

    public void beforeEvaluate(Project project) {
        this.buildProfile.getProjectProfile(project.getPath()).getConfigurationOperation().setStart(System.currentTimeMillis());
    }

    public void afterEvaluate(Project project, ProjectState state) {
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project.getPath());
        projectProfile.getConfigurationOperation().setFinish(this.timeProvider.getCurrentTime());
    }

    public void beforeExecute(Task task) {
        Project project = task.getProject();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project.getPath());
        projectProfile.getTaskProfile(task.getPath()).setStart(this.timeProvider.getCurrentTime());
    }

    public void afterExecute(Task task, TaskState state) {
        Project project = task.getProject();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project.getPath());
        TaskExecution taskExecution = projectProfile.getTaskProfile(task.getPath());
        taskExecution.setFinish(this.timeProvider.getCurrentTime());
        taskExecution.completed(state);
    }

    public void beforeResolve(ResolvableDependencies dependencies) {
        ContinuousOperation profile = this.buildProfile.getDependencySetProfile(dependencies.getPath());
        profile.setStart(this.timeProvider.getCurrentTime());
    }

    public void afterResolve(ResolvableDependencies dependencies) {
        ContinuousOperation profile = this.buildProfile.getDependencySetProfile(dependencies.getPath());
        profile.setFinish(this.timeProvider.getCurrentTime());
    }
}

