/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.gradle.api.PathValidation;
import org.gradle.api.Script;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.DefaultFileOperations;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.internal.nativeplatform.filesystem.FileSystems;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.ExecResult;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultScript
extends BasicScript {
    private static final Logger LOGGER = Logging.getLogger(Script.class);
    private ServiceRegistry services;
    private FileOperations fileOperations;
    private ProcessOperations processOperations;
    private LoggingManager loggingManager;

    @Override
    public void init(Object target, ServiceRegistry services) {
        super.init(target, services);
        this.services = services;
        this.loggingManager = (LoggingManager)services.get(LoggingManager.class);
        this.fileOperations = target instanceof FileOperations ? (FileOperations)target : (this.getScriptSource().getResource().getFile() != null ? new DefaultFileOperations(new BaseDirFileResolver(FileSystems.getDefault(), this.getScriptSource().getResource().getFile().getParentFile()), null, null) : new DefaultFileOperations(new IdentityFileResolver(), null, null));
        this.processOperations = (ProcessOperations)((Object)this.fileOperations);
    }

    @Override
    public FileResolver getFileResolver() {
        return this.fileOperations.getFileResolver();
    }

    private DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.getFileResolver(), (ScriptPluginFactory)this.services.get(ScriptPluginFactory.class), this.getScriptTarget());
    }

    @Override
    public void apply(Closure closure) {
        DefaultObjectConfigurationAction action = this.createObjectConfigurationAction();
        ConfigureUtil.configure(closure, action);
        action.execute();
    }

    public void apply(Map options) {
        DefaultObjectConfigurationAction action = this.createObjectConfigurationAction();
        ConfigureUtil.configureByMap(options, action);
        action.execute();
    }

    @Override
    public ScriptHandler getBuildscript() {
        return (ScriptHandler)this.services.get(ScriptHandler.class);
    }

    @Override
    public void buildscript(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getBuildscript());
    }

    @Override
    public File file(Object path) {
        return this.fileOperations.file(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.fileOperations.file(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.fileOperations.uri(path);
    }

    @Override
    public ConfigurableFileCollection files(Object ... paths) {
        return this.fileOperations.files(paths);
    }

    @Override
    public ConfigurableFileCollection files(Object paths, Closure configureClosure) {
        return this.fileOperations.files(paths, configureClosure);
    }

    @Override
    public String relativePath(Object path) {
        return this.fileOperations.relativePath(path);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        return this.fileOperations.fileTree(baseDir);
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return this.fileOperations.fileTree(args);
    }

    @Override
    public ConfigurableFileTree fileTree(Closure closure) {
        DeprecationLogger.nagUserOfDeprecated("fileTree(Closure)", "Use fileTree((Object){ baseDir }) to have the closure used as the file tree base directory");
        return this.fileOperations.fileTree(closure);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir, Closure configureClosure) {
        return this.fileOperations.fileTree(baseDir, configureClosure);
    }

    @Override
    public FileTree zipTree(Object zipPath) {
        return this.fileOperations.zipTree(zipPath);
    }

    @Override
    public FileTree tarTree(Object tarPath) {
        return this.fileOperations.tarTree(tarPath);
    }

    @Override
    public ResourceHandler getResources() {
        return this.fileOperations.getResources();
    }

    @Override
    public WorkResult copy(Closure closure) {
        return this.fileOperations.copy(closure);
    }

    @Override
    public CopySpec copySpec(Closure closure) {
        return this.fileOperations.copySpec(closure);
    }

    @Override
    public File mkdir(Object path) {
        return this.fileOperations.mkdir(path);
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.fileOperations.delete(paths);
    }

    @Override
    public ExecResult javaexec(Closure closure) {
        return this.processOperations.javaexec(closure);
    }

    @Override
    public ExecResult exec(Closure closure) {
        return this.processOperations.exec(closure);
    }

    @Override
    public LoggingManager getLogging() {
        return this.loggingManager;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    public String toString() {
        return "script";
    }
}

