/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import com.google.common.collect.Iterables;
import java.util.TreeSet;
import org.gradle.api.internal.TaskInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskInfo
implements Comparable<TaskInfo> {
    private final TaskInternal task;
    private TaskExecutionState state;
    private Throwable executionFailure;
    private final TreeSet<TaskInfo> hardSuccessors = new TreeSet();
    private final TreeSet<TaskInfo> softSuccessors = new TreeSet();

    public TaskInfo(TaskInternal task) {
        this.task = task;
        this.state = TaskExecutionState.NOT_REQUIRED;
    }

    public TaskInternal getTask() {
        return this.task;
    }

    public boolean isReady() {
        return this.state == TaskExecutionState.READY;
    }

    public boolean isComplete() {
        return this.state == TaskExecutionState.EXECUTED || this.state == TaskExecutionState.SKIPPED || this.state == TaskExecutionState.NOT_REQUIRED;
    }

    public boolean isSuccessful() {
        return this.state == TaskExecutionState.EXECUTED && !this.isFailed() || this.state == TaskExecutionState.NOT_REQUIRED;
    }

    public boolean isFailed() {
        return this.getTaskFailure() != null || this.getExecutionFailure() != null;
    }

    public void startExecution() {
        assert (this.state == TaskExecutionState.READY);
        this.state = TaskExecutionState.EXECUTING;
    }

    public void finishExecution() {
        assert (this.state == TaskExecutionState.EXECUTING);
        this.state = TaskExecutionState.EXECUTED;
    }

    public void skipExecution() {
        assert (this.state == TaskExecutionState.READY);
        this.state = TaskExecutionState.SKIPPED;
    }

    public void setExecutionFailure(Throwable failure) {
        assert (this.state == TaskExecutionState.EXECUTING);
        this.executionFailure = failure;
    }

    public Throwable getExecutionFailure() {
        return this.executionFailure;
    }

    public Throwable getTaskFailure() {
        return this.getTask().getState().getFailure();
    }

    public boolean allDependenciesComplete() {
        for (TaskInfo dependency : Iterables.concat(this.softSuccessors, this.hardSuccessors)) {
            if (dependency.isComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean allDependenciesSuccessful() {
        for (TaskInfo dependency : this.hardSuccessors) {
            if (dependency.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    public TreeSet<TaskInfo> getHardSuccessors() {
        return this.hardSuccessors;
    }

    public TreeSet<TaskInfo> getSoftSuccessors() {
        return this.softSuccessors;
    }

    public boolean getRequired() {
        return this.state != TaskExecutionState.NOT_REQUIRED;
    }

    public void setRequired(boolean required) {
        this.state = required ? TaskExecutionState.READY : TaskExecutionState.NOT_REQUIRED;
    }

    public void addHardSuccessor(TaskInfo toNode) {
        this.hardSuccessors.add(toNode);
    }

    public void addSoftSuccessor(TaskInfo toNode) {
        this.softSuccessors.add(toNode);
    }

    @Override
    public int compareTo(TaskInfo otherInfo) {
        return this.task.compareTo(otherInfo.getTask());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskExecutionState {
        NOT_REQUIRED,
        READY,
        EXECUTING,
        EXECUTED,
        SKIPPED;

    }
}

