/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.execution.taskgraph.DefaultTaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParallelTaskPlanExecutor
extends DefaultTaskPlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(ParallelTaskPlanExecutor.class);
    private final TaskArtifactStateCacheAccess stateCacheAccess;
    private final int executorCount;

    public ParallelTaskPlanExecutor(TaskArtifactStateCacheAccess cacheAccess, int numberOfParallelExecutors) {
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.stateCacheAccess = cacheAccess;
        this.executorCount = numberOfParallelExecutors;
    }

    @Override
    public void process(final TaskExecutionPlan taskExecutionPlan, final TaskExecutionListener taskListener) {
        this.stateCacheAccess.longRunningOperation("Executing all tasks", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DefaultExecutorFactory factory = new DefaultExecutorFactory();
                try {
                    ParallelTaskPlanExecutor.this.doProcess(taskExecutionPlan, taskListener, (ExecutorFactory)factory);
                    taskExecutionPlan.awaitCompletion();
                }
                finally {
                    factory.stop();
                }
            }
        });
    }

    private void doProcess(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener, ExecutorFactory factory) {
        List<Project> projects = this.getAllProjects(taskExecutionPlan);
        int numExecutors = Math.min(this.executorCount, projects.size());
        numExecutors = Math.min(numExecutors, 4);
        LOGGER.info("Using {} parallel executor threads", numExecutors);
        for (int i = 0; i < numExecutors; ++i) {
            TaskExecutorWorker worker = new TaskExecutorWorker(taskExecutionPlan, taskListener);
            StoppableExecutor executor = factory.create("Task worker " + (i + 1));
            executor.execute((Runnable)worker);
        }
    }

    private List<Project> getAllProjects(TaskExecutionPlan taskExecutionPlan) {
        LinkedHashSet<Project> uniqueProjects = new LinkedHashSet<Project>();
        for (Task task : taskExecutionPlan.getTasks()) {
            uniqueProjects.add(task.getProject());
        }
        return new ArrayList<Project>(uniqueProjects);
    }

    private class TaskExecutorWorker
    implements Runnable {
        private final TaskExecutionPlan taskExecutionPlan;
        private final TaskExecutionListener taskListener;
        private long busyMs;
        private long waitedForCacheMs;

        private TaskExecutorWorker(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener) {
            this.taskExecutionPlan = taskExecutionPlan;
            this.taskListener = taskListener;
        }

        public void run() {
            TaskInfo task;
            long start = System.currentTimeMillis();
            while ((task = this.taskExecutionPlan.getTaskToExecute()) != null) {
                this.executeTaskWithCacheLock(task);
            }
            long total = System.currentTimeMillis() - start;
            LOGGER.info("Parallel worker [{}] stopped, busy: {}, idle: {}, waited for cache: {}", Thread.currentThread(), Clock.prettyTime(this.busyMs), Clock.prettyTime(total - this.busyMs), Clock.prettyTime(this.waitedForCacheMs));
        }

        private void executeTaskWithCacheLock(final TaskInfo taskInfo) {
            String taskPath = taskInfo.getTask().getPath();
            LOGGER.info(taskPath + " (" + Thread.currentThread() + " - start");
            final long start = System.currentTimeMillis();
            ParallelTaskPlanExecutor.this.stateCacheAccess.useCache("Executing " + taskPath, new Runnable(){

                public void run() {
                    TaskExecutorWorker.this.waitedForCacheMs += System.currentTimeMillis() - start;
                    ParallelTaskPlanExecutor.this.processTask(taskInfo, TaskExecutorWorker.this.taskExecutionPlan, TaskExecutorWorker.this.taskListener);
                }
            });
            this.busyMs += System.currentTimeMillis() - start;
            LOGGER.info(taskPath + " (" + Thread.currentThread() + ") - complete");
        }
    }
}

