/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.taskgraph.TaskDependencyGraph;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.graph.GraphNodeRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultTaskExecutionPlan
implements TaskExecutionPlan {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Set<TaskInfo> entryTasks = new LinkedHashSet<TaskInfo>();
    private final TaskDependencyGraph graph = new TaskDependencyGraph();
    private final LinkedHashMap<Task, TaskInfo> executionPlan = new LinkedHashMap();
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private Spec<? super Task> filter = Specs.satisfyAll();
    private TaskFailureHandler failureHandler = new RethrowingFailureHandler();
    private final List<String> runningProjects = new ArrayList<String>();

    DefaultTaskExecutionPlan() {
    }

    public void addToTaskGraph(Collection<? extends Task> tasks) {
        ArrayList<? extends Task> queue = new ArrayList<Task>(tasks);
        Collections.sort(queue);
        for (Task task : queue) {
            this.entryTasks.add(this.graph.addNode(task));
        }
        HashSet<Task> visiting = new HashSet<Task>();
        CachingTaskDependencyResolveContext cachingTaskDependencyResolveContext = new CachingTaskDependencyResolveContext();
        while (!queue.isEmpty()) {
            boolean filtered;
            Task task = (Task)queue.get(0);
            TaskInfo node = this.graph.addNode(task);
            if (node.getRequired()) {
                queue.remove(0);
                continue;
            }
            boolean bl = filtered = !this.filter.isSatisfiedBy((Object)task);
            if (filtered) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(task)) {
                Set<? extends Task> dependsOnTasks = cachingTaskDependencyResolveContext.getDependencies(task);
                for (Task task2 : dependsOnTasks) {
                    if (visiting.contains(task2)) continue;
                    queue.add(0, task2);
                }
                continue;
            }
            queue.remove(0);
            visiting.remove(task);
            node.setRequired(true);
            Set<? extends Task> dependencies = cachingTaskDependencyResolveContext.getDependencies(task);
            for (Task task3 : dependencies) {
                this.graph.addHardEdge(node, task3);
            }
            for (Task task4 : task.getMustRunAfter().getDependencies(task)) {
                this.graph.addSoftEdge(node, task4);
            }
        }
    }

    private <T> void addAllReversed(List<T> list, TreeSet<T> set) {
        List elements = CollectionUtils.toList(set);
        Collections.reverse(elements);
        list.addAll(elements);
    }

    public void determineExecutionPlan() {
        ArrayList<TaskInfo> nodeQueue = new ArrayList<TaskInfo>(this.entryTasks);
        HashSet<TaskInfo> visitingNodes = new HashSet<TaskInfo>();
        while (!nodeQueue.isEmpty()) {
            TaskInfo taskNode = (TaskInfo)nodeQueue.get(0);
            if (!taskNode.getRequired() || this.executionPlan.containsKey(taskNode.getTask())) {
                nodeQueue.remove(0);
                continue;
            }
            if (visitingNodes.add(taskNode)) {
                ArrayList dependsOnTasks = new ArrayList();
                this.addAllReversed(dependsOnTasks, taskNode.getHardSuccessors());
                this.addAllReversed(dependsOnTasks, taskNode.getSoftSuccessors());
                for (TaskInfo dependsOnTask : dependsOnTasks) {
                    if (visitingNodes.contains(dependsOnTask)) {
                        this.onOrderingCycle();
                    }
                    nodeQueue.add(0, dependsOnTask);
                }
                continue;
            }
            nodeQueue.remove(0);
            visitingNodes.remove(taskNode);
            this.executionPlan.put(taskNode.getTask(), taskNode);
        }
    }

    private void onOrderingCycle() {
        CachingDirectedGraphWalker<TaskInfo, Void> graphWalker = new CachingDirectedGraphWalker<TaskInfo, Void>(new DirectedGraph<TaskInfo, Void>(){

            @Override
            public void getNodeValues(TaskInfo node, Collection<? super Void> values, Collection<? super TaskInfo> connectedNodes) {
                connectedNodes.addAll(node.getHardSuccessors());
                connectedNodes.addAll(node.getSoftSuccessors());
            }
        });
        graphWalker.add((Iterable<TaskInfo>)this.entryTasks);
        final ArrayList firstCycle = new ArrayList(graphWalker.findCycles().get(0));
        Collections.sort(firstCycle);
        DirectedGraphRenderer<TaskInfo> graphRenderer = new DirectedGraphRenderer<TaskInfo>(new GraphNodeRenderer<TaskInfo>(){

            @Override
            public void renderTo(TaskInfo node, StyledTextOutput output) {
                output.withStyle(StyledTextOutput.Style.Identifier).text(node.getTask().getPath());
            }
        }, new DirectedGraph<TaskInfo, Object>(){

            @Override
            public void getNodeValues(TaskInfo node, Collection<? super Object> values, Collection<? super TaskInfo> connectedNodes) {
                for (TaskInfo dependency : firstCycle) {
                    if (!node.getHardSuccessors().contains(dependency) && !node.getSoftSuccessors().contains(dependency)) continue;
                    connectedNodes.add(dependency);
                }
            }
        });
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo((TaskInfo)firstCycle.get(0), writer);
        throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.graph.clear();
            this.entryTasks.clear();
            this.executionPlan.clear();
            this.failures.clear();
            this.runningProjects.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Task> getTasks() {
        return new ArrayList<Task>(this.executionPlan.keySet());
    }

    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    public void useFailureHandler(TaskFailureHandler handler) {
        this.failureHandler = handler;
    }

    @Override
    public TaskInfo getTaskToExecute() {
        this.lock.lock();
        try {
            while (true) {
                TaskInfo nextMatching = null;
                boolean allTasksComplete = true;
                for (TaskInfo taskInfo : this.executionPlan.values()) {
                    boolean bl = allTasksComplete = allTasksComplete && taskInfo.isComplete();
                    if (!taskInfo.isReady() || !taskInfo.allDependenciesComplete() || this.runningProjects.contains(taskInfo.getTask().getProject().getPath())) continue;
                    nextMatching = taskInfo;
                    break;
                }
                if (allTasksComplete) {
                    Iterator<TaskInfo> i$ = null;
                    return i$;
                }
                if (nextMatching == null) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (nextMatching.allDependenciesSuccessful()) {
                    nextMatching.startExecution();
                    this.runningProjects.add(nextMatching.getTask().getProject().getPath());
                    TaskInfo taskInfo = nextMatching;
                    return taskInfo;
                }
                nextMatching.skipExecution();
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskComplete(TaskInfo taskInfo) {
        this.lock.lock();
        try {
            if (taskInfo.isFailed()) {
                this.handleFailure(taskInfo);
            }
            taskInfo.finishExecution();
            this.runningProjects.remove(taskInfo.getTask().getProject().getPath());
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleFailure(TaskInfo taskInfo) {
        Throwable executionFailure = taskInfo.getExecutionFailure();
        if (executionFailure != null) {
            this.abortExecution();
            this.failures.add(executionFailure);
            return;
        }
        try {
            this.failureHandler.onTaskFailure(taskInfo.getTask());
            this.failures.add(taskInfo.getTaskFailure());
        }
        catch (Exception e) {
            this.abortExecution();
            this.failures.add(e);
        }
    }

    private void abortExecution() {
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (!taskInfo.isReady()) continue;
            taskInfo.skipExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitCompletion() {
        this.lock.lock();
        try {
            while (!this.allTasksComplete()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.rethrowFailures();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void rethrowFailures() {
        if (this.failures.isEmpty()) {
            return;
        }
        if (this.failures.size() > 1) {
            throw new MultipleBuildFailures(this.failures);
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)this.failures.get(0));
    }

    private boolean allTasksComplete() {
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (taskInfo.isComplete()) continue;
            return false;
        }
        return true;
    }

    private static class RethrowingFailureHandler
    implements TaskFailureHandler {
        private RethrowingFailureHandler() {
        }

        public void onTaskFailure(Task task) {
            task.getState().rethrowFailure();
        }
    }
}

