/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectDependencies2TaskResolver
implements ProjectEvaluationListener {
    private static Logger logger = LoggerFactory.getLogger(ProjectDependencies2TaskResolver.class);

    public void beforeEvaluate(Project project) {
    }

    public void afterEvaluate(Project project, ProjectState state) {
        for (Project dependsOnProject : project.getDependsOnProjects()) {
            logger.debug("Checking task dependencies for project: {} dependsOn: {}", (Object)project, (Object)dependsOnProject);
            for (Task task : project.getTasks()) {
                String taskName = task.getName();
                Task dependentTask = (Task)dependsOnProject.getTasks().findByName(taskName);
                if (dependentTask == null) continue;
                logger.debug("Setting task dependencies for task: {}", (Object)taskName);
                task.dependsOn(dependentTask);
            }
        }
    }
}

