/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.CacheUsage;
import org.gradle.api.Action;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.DefaultPersistentDirectoryCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.DelegateOnDemandPersistentDirectoryCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.cache.internal.SimpleStateCache;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.internal.Factory;
import org.gradle.messaging.serialize.DefaultSerializer;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheFactory
implements Factory<CacheFactory> {
    private final Map<File, DirCacheReference> dirCaches = new HashMap<File, DirCacheReference>();
    private final FileLockManager lockManager;

    public DefaultCacheFactory(FileLockManager fileLockManager) {
        this.lockManager = fileLockManager;
    }

    public CacheFactory create() {
        return new CacheFactoryImpl();
    }

    void onOpen(Object cache) {
    }

    void onClose(Object cache) {
    }

    public void close() {
        for (DirCacheReference dirCacheReference : this.dirCaches.values()) {
            dirCacheReference.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StateCacheReference<E>
    extends NestedCacheReference<SimpleStateCache<E>> {
        private StateCacheReference(SimpleStateCache<E> cache, DirCacheReference backingCache) {
            super(cache, backingCache);
        }

        @Override
        public void close() {
            this.backingCache.stateCache = null;
            super.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexedCacheReference<K, V>
    extends NestedCacheReference<MultiProcessSafePersistentIndexedCache<K, V>> {
        private IndexedCacheReference(MultiProcessSafePersistentIndexedCache<K, V> cache, DirCacheReference backingCache) {
            super(cache, backingCache);
        }

        @Override
        public void close() {
            this.backingCache.indexedCache = null;
            ((MultiProcessSafePersistentIndexedCache)this.getCache()).close();
            super.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NestedCacheReference<T>
    extends BasicCacheReference<T> {
        protected final DirCacheReference backingCache;

        protected NestedCacheReference(T cache, DirCacheReference backingCache) {
            super(cache);
            this.backingCache = backingCache;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirCacheReference
    extends BasicCacheReference<ReferencablePersistentCache> {
        private final Map<String, ?> properties;
        private final FileLockManager.LockMode lockMode;
        IndexedCacheReference indexedCache;
        StateCacheReference stateCache;
        CacheFactoryImpl rebuiltBy;

        public DirCacheReference(ReferencablePersistentCache cache, Map<String, ?> properties, FileLockManager.LockMode lockMode) {
            super(cache);
            this.properties = properties;
            this.lockMode = lockMode;
        }

        public <E> StateCacheReference<E> getStateCache(Serializer<E> serializer) {
            if (this.stateCache == null) {
                SimpleStateCache<E> stateCache = new SimpleStateCache<E>(new File(((ReferencablePersistentCache)this.getCache()).getBaseDir(), "state.bin"), ((ReferencablePersistentCache)this.getCache()).getLock(), serializer);
                this.stateCache = new StateCacheReference(stateCache, this);
            }
            return this.stateCache;
        }

        public <K, V> IndexedCacheReference<K, V> getIndexedCache(Serializer<V> serializer) {
            if (this.indexedCache == null) {
                final BTreePersistentIndexedCache indexedCache = new BTreePersistentIndexedCache(new File(((ReferencablePersistentCache)this.getCache()).getBaseDir(), "cache.bin"), new DefaultSerializer(), serializer);
                Factory cacheFactory = new Factory<BTreePersistentIndexedCache<K, V>>(){

                    public BTreePersistentIndexedCache<K, V> create() {
                        return indexedCache;
                    }
                };
                MultiProcessSafePersistentIndexedCache safeCache = new MultiProcessSafePersistentIndexedCache(cacheFactory, ((ReferencablePersistentCache)this.getCache()).getLock());
                this.indexedCache = new IndexedCacheReference(safeCache, this);
            }
            return this.indexedCache;
        }

        @Override
        public void close() {
            DefaultCacheFactory.this.dirCaches.values().remove(this);
            ((ReferencablePersistentCache)this.getCache()).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BasicCacheReference<T> {
        private Set<CacheFactoryImpl> references = new HashSet<CacheFactoryImpl>();
        private final T cache;

        protected BasicCacheReference(T cache) {
            this.cache = cache;
            DefaultCacheFactory.this.onOpen(cache);
        }

        public T getCache() {
            return this.cache;
        }

        public void release(CacheFactoryImpl owner) {
            boolean removed = this.references.remove(owner);
            assert (removed);
            if (this.references.isEmpty()) {
                DefaultCacheFactory.this.onClose(this.cache);
                this.close();
            }
        }

        public void addReference(CacheFactoryImpl owner) {
            this.references.add(owner);
            owner.caches.add(this);
        }

        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheFactoryImpl
    implements CacheFactory {
        private final Set<BasicCacheReference<?>> caches = new LinkedHashSet();

        private CacheFactoryImpl() {
        }

        private DirCacheReference doOpenDir(File cacheDir, String displayName, CacheUsage usage, CacheValidator validator, Map<String, ?> properties, FileLockManager.LockMode lockMode, Action<? super PersistentCache> action) {
            File canonicalDir = GFileUtils.canonicalise(cacheDir);
            DirCacheReference dirCacheReference = (DirCacheReference)DefaultCacheFactory.this.dirCaches.get(canonicalDir);
            if (dirCacheReference == null) {
                if (lockMode.equals((Object)FileLockManager.LockMode.None)) {
                    DefaultPersistentDirectoryCache nestedCache = new DefaultPersistentDirectoryCache(canonicalDir, displayName, usage, validator, properties, FileLockManager.LockMode.Exclusive, action, DefaultCacheFactory.this.lockManager);
                    DelegateOnDemandPersistentDirectoryCache onDemandDache = new DelegateOnDemandPersistentDirectoryCache(nestedCache);
                    onDemandDache.open();
                    dirCacheReference = new DirCacheReference(onDemandDache, properties, lockMode);
                    DefaultCacheFactory.this.dirCaches.put(canonicalDir, dirCacheReference);
                } else {
                    DefaultPersistentDirectoryCache cache = new DefaultPersistentDirectoryCache(canonicalDir, displayName, usage, validator, properties, lockMode, action, DefaultCacheFactory.this.lockManager);
                    cache.open();
                    dirCacheReference = new DirCacheReference(cache, properties, lockMode);
                    DefaultCacheFactory.this.dirCaches.put(canonicalDir, dirCacheReference);
                }
            } else {
                if (usage == CacheUsage.REBUILD && dirCacheReference.rebuiltBy != this) {
                    throw new IllegalStateException(String.format("Cannot rebuild cache '%s' as it is already open.", cacheDir));
                }
                if (lockMode != dirCacheReference.lockMode) {
                    throw new IllegalStateException(String.format("Cannot open cache '%s' with %s lock mode as it is already open with %s lock mode.", cacheDir, lockMode.toString().toLowerCase(), dirCacheReference.lockMode.toString().toLowerCase()));
                }
                if (!properties.equals(dirCacheReference.properties)) {
                    throw new IllegalStateException(String.format("Cache '%s' is already open with different state.", cacheDir));
                }
            }
            if (usage == CacheUsage.REBUILD) {
                dirCacheReference.rebuiltBy = this;
            }
            dirCacheReference.addReference(this);
            return dirCacheReference;
        }

        @Override
        public PersistentCache openStore(File storeDir, String displayName, FileLockManager.LockMode lockMode, Action<? super PersistentCache> initializer) throws CacheOpenException {
            if (initializer != null) {
                throw new UnsupportedOperationException("Initializer actions are not currently supported by the directory store implementation.");
            }
            File canonicalDir = GFileUtils.canonicalise(storeDir);
            DirCacheReference dirCacheReference = (DirCacheReference)DefaultCacheFactory.this.dirCaches.get(canonicalDir);
            if (dirCacheReference == null) {
                DefaultPersistentDirectoryStore cache = new DefaultPersistentDirectoryStore(canonicalDir, displayName, lockMode, DefaultCacheFactory.this.lockManager);
                cache.open();
                dirCacheReference = new DirCacheReference(cache, Collections.emptyMap(), lockMode);
                DefaultCacheFactory.this.dirCaches.put(canonicalDir, dirCacheReference);
            }
            dirCacheReference.addReference(this);
            return (PersistentCache)dirCacheReference.getCache();
        }

        @Override
        public PersistentCache open(File cacheDir, String displayName, CacheUsage usage, CacheValidator cacheValidator, Map<String, ?> properties, FileLockManager.LockMode lockMode, Action<? super PersistentCache> initializer) {
            DirCacheReference dirCacheReference = this.doOpenDir(cacheDir, displayName, usage, cacheValidator, properties, lockMode, initializer);
            return (PersistentCache)dirCacheReference.getCache();
        }

        @Override
        public <E> PersistentStateCache<E> openStateCache(File cacheDir, CacheUsage usage, CacheValidator validator, Map<String, ?> properties, FileLockManager.LockMode lockMode, Serializer<E> serializer) {
            StateCacheReference<E> cacheReference = this.doOpenDir(cacheDir, null, usage, validator, properties, lockMode, null).getStateCache(serializer);
            cacheReference.addReference(this);
            return (PersistentStateCache)cacheReference.getCache();
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> openIndexedCache(File cacheDir, CacheUsage usage, CacheValidator validator, Map<String, ?> properties, FileLockManager.LockMode lockMode, Serializer<V> serializer) {
            if (lockMode != FileLockManager.LockMode.Exclusive) {
                throw new UnsupportedOperationException(String.format("No %s mode indexed cache implementation is available.", new Object[]{lockMode}));
            }
            IndexedCacheReference cacheReference = this.doOpenDir(cacheDir, null, usage, validator, properties, FileLockManager.LockMode.Exclusive, null).getIndexedCache(serializer);
            cacheReference.addReference(this);
            return (PersistentIndexedCache)cacheReference.getCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                ArrayList caches = new ArrayList(this.caches);
                Collections.reverse(caches);
                for (BasicCacheReference basicCacheReference : caches) {
                    basicCacheReference.release(this);
                }
            }
            finally {
                this.caches.clear();
            }
        }
    }
}

