/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.tasks.ContextualTaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipUpToDateTaskExecuter
implements ContextualTaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipUpToDateTaskExecuter.class);
    private final ContextualTaskExecuter executer;
    private final TaskArtifactStateRepository repository;

    public SkipUpToDateTaskExecuter(TaskArtifactStateRepository repository, ContextualTaskExecuter executer) {
        this.executer = executer;
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        LOGGER.debug("Determining if {} is up-to-date", (Object)task);
        TaskArtifactState taskArtifactState = this.repository.getStateFor(task);
        try {
            if (taskArtifactState.isUpToDate()) {
                LOGGER.info("Skipping {} as it is up-to-date", (Object)task);
                state.upToDate();
                return;
            }
            LOGGER.debug("{} is not up-to-date", (Object)task);
            task.getOutputs().setHistory(taskArtifactState.getExecutionHistory());
            context.setTaskArtifactState(taskArtifactState);
            taskArtifactState.beforeTask();
            try {
                this.executer.execute(task, state, context);
                if (state.getFailure() == null) {
                    taskArtifactState.afterTask();
                }
            }
            finally {
                task.getOutputs().setHistory(null);
                context.setTaskArtifactState(null);
            }
        }
        finally {
            taskArtifactState.finished();
        }
    }
}

