/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.util.ObservableList;
import java.beans.PropertyChangeEvent;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.util.DeprecationLogger;

public class TaskStatusNagger {
    private static final String DEPRECATION_MESSAGE = "Calling %s after task execution has started";
    private static final String EXPLANAITION = "Check the configuration of %s";
    private static final String EXPLANAITION_WITH_HINT = "Check the configuration of %s. You may have misused '<<' at task declaration";
    private final TaskInternal taskInternal;
    private boolean nagUser = true;
    private boolean executingleftShiftAction;

    public TaskStatusNagger(TaskInternal taskInternal) {
        this.taskInternal = taskInternal;
    }

    public void nagIfTaskNotInConfigurableState(String method) {
        if (!this.taskInternal.getStateInternal().isConfigurable() && this.nagUser) {
            this.warn(method);
        }
    }

    public void nagAboutMutatingListIfTaskNotInConfigurableState(String listname, PropertyChangeEvent evt) {
        if (!this.taskInternal.getStateInternal().isConfigurable() && this.nagUser && evt instanceof ObservableList.ElementEvent) {
            switch (((ObservableList.ElementEvent)evt).getChangeType()) {
                case ADDED: {
                    this.warn(String.format("%s.%s", listname, "add()"));
                    break;
                }
                case UPDATED: {
                    this.warn(String.format("%s.%s", listname, "set(int, Object)"));
                    break;
                }
                case REMOVED: {
                    this.warn(String.format("%s.%s", listname, "remove()"));
                    break;
                }
                case CLEARED: {
                    this.warn(String.format("%s.%s", listname, "clear()"));
                    break;
                }
                case MULTI_ADD: {
                    this.warn(String.format("%s.%s", listname, "addAll()"));
                    break;
                }
                case MULTI_REMOVE: {
                    this.warn(String.format("%s.%s", listname, "removeAll()"));
                }
            }
        }
    }

    public ContextAwareTaskAction leftShift(final ContextAwareTaskAction action) {
        return new ContextAwareTaskAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Task task) {
                TaskStatusNagger.this.executingleftShiftAction = true;
                try {
                    action.execute(task);
                }
                finally {
                    TaskStatusNagger.this.executingleftShiftAction = false;
                }
            }

            public void contextualise(TaskExecutionContext context) {
                action.contextualise(context);
            }
        };
    }

    private void warn(String method) {
        if (this.executingleftShiftAction) {
            DeprecationLogger.nagUserOfDeprecated(String.format(DEPRECATION_MESSAGE, method), String.format(EXPLANAITION_WITH_HINT, this.taskInternal));
        } else {
            DeprecationLogger.nagUserOfDeprecated(String.format(DEPRECATION_MESSAGE, method), String.format(EXPLANAITION, this.taskInternal));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whileDisabled(Runnable runnable) {
        this.nagUser = false;
        try {
            runnable.run();
        }
        finally {
            this.nagUser = true;
        }
    }
}

