/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.PathValidation;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.Task;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.DynamicPropertyNamer;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.FactoryNamedDomainObjectContainer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ScriptClassLoaderProvider;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.ProjectScript;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.api.internal.project.ServiceRegistryFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.Directory;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ProjectEvaluator;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.process.ExecResult;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProject
extends AbstractPluginAware
implements ProjectInternal,
DynamicObjectAware {
    private static Logger buildLogger = Logging.getLogger(Project.class);
    private ServiceRegistryFactory services;
    private final ProjectInternal rootProject;
    private final GradleInternal gradle;
    private ProjectEvaluator projectEvaluator;
    private ScriptSource buildScriptSource;
    private final File projectDir;
    private final ProjectInternal parent;
    private final String name;
    private Object group;
    private Object version;
    private Object status;
    private final Map<String, Project> childProjects = new HashMap<String, Project>();
    private List<String> defaultTasks = new ArrayList<String>();
    private Set<Project> dependsOnProjects = new HashSet<Project>();
    private ProjectStateInternal state;
    private FileResolver fileResolver;
    private FileOperations fileOperations;
    private ProcessOperations processOperations;
    private Factory<AntBuilder> antBuilderFactory;
    private AntBuilder ant;
    private Object buildDir = "build";
    private PluginContainer pluginContainer;
    private final int depth;
    private TaskContainerInternal taskContainer;
    private TaskContainerInternal implicitTasksContainer;
    private ProjectRegistry<ProjectInternal> projectRegistry;
    private DependencyHandler dependencyHandler;
    private ConfigurationContainerInternal configurationContainer;
    private ArtifactHandler artifactHandler;
    private RepositoryHandler repositoryHandler;
    private ScriptHandler scriptHandler;
    private ScriptClassLoaderProvider scriptClassLoaderProvider;
    private ListenerBroadcast<ProjectEvaluationListener> evaluationListener = new ListenerBroadcast<ProjectEvaluationListener>(ProjectEvaluationListener.class);
    private LoggingManagerInternal loggingManager;
    private SoftwareComponentContainer softwareComponentContainer;
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private final Path path;
    private ScriptPluginFactory scriptPluginFactory;

    public AbstractProject(String name, ProjectInternal parent, File projectDir, ScriptSource buildScriptSource, GradleInternal gradle, ServiceRegistryFactory serviceRegistryFactory) {
        assert (name != null);
        this.rootProject = parent != null ? parent.getRootProject() : this;
        this.projectDir = projectDir;
        this.parent = parent;
        this.name = name;
        this.state = new ProjectStateInternal();
        this.buildScriptSource = buildScriptSource;
        this.gradle = gradle;
        if (parent == null) {
            this.path = Path.ROOT;
            this.depth = 0;
        } else {
            String path = parent.absoluteProjectPath(name);
            this.depth = parent.getDepth() + 1;
            this.path = Path.path(path);
        }
        this.services = serviceRegistryFactory.createFor(this);
        this.fileResolver = (FileResolver)this.services.get(FileResolver.class);
        this.antBuilderFactory = this.services.getFactory(AntBuilder.class);
        this.taskContainer = (TaskContainerInternal)this.services.newInstance(TaskContainerInternal.class);
        this.implicitTasksContainer = (TaskContainerInternal)this.services.newInstance(TaskContainerInternal.class);
        this.fileOperations = (FileOperations)this.services.get(FileOperations.class);
        this.processOperations = (ProcessOperations)this.services.get(ProcessOperations.class);
        this.projectEvaluator = (ProjectEvaluator)this.services.get(ProjectEvaluator.class);
        this.repositoryHandler = (RepositoryHandler)this.services.get(RepositoryHandler.class);
        this.configurationContainer = (ConfigurationContainerInternal)this.services.get(ConfigurationContainerInternal.class);
        this.pluginContainer = (PluginContainer)this.services.get(PluginContainer.class);
        this.artifactHandler = (ArtifactHandler)this.services.get(ArtifactHandler.class);
        this.dependencyHandler = (DependencyHandler)this.services.get(DependencyHandler.class);
        this.scriptHandler = (ScriptHandler)this.services.get(ScriptHandler.class);
        this.scriptClassLoaderProvider = (ScriptClassLoaderProvider)this.services.get(ScriptClassLoaderProvider.class);
        this.projectRegistry = (ProjectRegistry)this.services.get(ProjectRegistry.class);
        this.loggingManager = (LoggingManagerInternal)this.services.get(LoggingManagerInternal.class);
        this.softwareComponentContainer = (SoftwareComponentContainer)this.services.get(SoftwareComponentContainer.class);
        this.scriptPluginFactory = (ScriptPluginFactory)this.services.get(ScriptPluginFactory.class);
        this.extensibleDynamicObject = new ExtensibleDynamicObject(this, (Instantiator)this.services.get(Instantiator.class));
        if (parent != null) {
            this.extensibleDynamicObject.setParent(parent.getInheritedScope());
        }
        this.extensibleDynamicObject.addObject(this.taskContainer.getTasksAsDynamicObject(), ExtensibleDynamicObject.Location.AfterConvention);
        this.evaluationListener.add(gradle.getProjectEvaluationBroadcaster());
    }

    @Override
    public ProjectInternal getRootProject() {
        return this.rootProject;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public PluginContainer getPlugins() {
        return this.pluginContainer;
    }

    public ProjectEvaluator getProjectEvaluator() {
        return this.projectEvaluator;
    }

    public void setProjectEvaluator(ProjectEvaluator projectEvaluator) {
        this.projectEvaluator = projectEvaluator;
    }

    @Override
    public ScriptHandler getBuildscript() {
        return this.scriptHandler;
    }

    @Override
    public void beforeCompile(ScriptPlugin configurer) {
        if (configurer.getSource() != this.buildScriptSource) {
            return;
        }
        configurer.setScriptBaseClass(ProjectScript.class);
        configurer.setClassLoaderProvider(this.scriptClassLoaderProvider);
    }

    @Override
    public void afterCompile(ScriptPlugin configurer, Script script) {
        if (configurer.getSource() != this.buildScriptSource) {
            return;
        }
        this.setScript(script);
    }

    @Override
    public File getBuildFile() {
        return this.getBuildscript().getSourceFile();
    }

    public void setScript(groovy.lang.Script buildScript) {
        this.extensibleDynamicObject.addObject(new BeanDynamicObject(buildScript).withNoProperties().withNotImplementsMissing(), ExtensibleDynamicObject.Location.BeforeConvention);
    }

    @Override
    public ScriptSource getBuildScriptSource() {
        return this.buildScriptSource;
    }

    @Override
    public File getRootDir() {
        return this.rootProject.getProjectDir();
    }

    @Override
    public ProjectInternal getParent() {
        return this.parent;
    }

    @Override
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.extensibleDynamicObject;
    }

    @Override
    public DynamicObject getInheritedScope() {
        return this.extensibleDynamicObject.getInheritable();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Object getGroup() {
        if (this.group != null) {
            return this.group;
        }
        if (this == this.rootProject) {
            return "";
        }
        return this.rootProject.getName() + (this.getParent() == this.rootProject ? "" : "." + this.getParent().getPath().substring(1).replace(':', '.'));
    }

    @Override
    public void setGroup(Object group) {
        this.group = group;
    }

    @Override
    public Object getVersion() {
        return this.version == null ? "unspecified" : this.version;
    }

    @Override
    public void setVersion(Object version) {
        this.version = version;
    }

    @Override
    public Object getStatus() {
        return this.status == null ? "release" : this.status;
    }

    @Override
    public void setStatus(Object status) {
        this.status = status;
    }

    @Override
    public Map<String, Project> getChildProjects() {
        return this.childProjects;
    }

    @Override
    public List<String> getDefaultTasks() {
        return this.defaultTasks;
    }

    @Override
    public void setDefaultTasks(List<String> defaultTasks) {
        this.defaultTasks = defaultTasks;
    }

    @Override
    public Set<Project> getDependsOnProjects() {
        return this.dependsOnProjects;
    }

    @Override
    public ProjectStateInternal getState() {
        return this.state;
    }

    @Override
    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setAnt(AntBuilder ant) {
        this.ant = ant;
    }

    @Override
    public ArtifactHandler getArtifacts() {
        return this.artifactHandler;
    }

    public void setArtifactHandler(ArtifactHandler artifactHandler) {
        this.artifactHandler = artifactHandler;
    }

    @Override
    public RepositoryHandler getRepositories() {
        return this.repositoryHandler;
    }

    @Override
    public ConfigurationContainerInternal getConfigurations() {
        return this.configurationContainer;
    }

    public void setConfigurationContainer(ConfigurationContainerInternal configurationContainer) {
        this.configurationContainer = configurationContainer;
    }

    @Override
    public Convention getConvention() {
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public ProjectRegistry<ProjectInternal> getProjectRegistry() {
        return this.projectRegistry;
    }

    @Override
    public int depthCompare(Project otherProject) {
        return new Integer(this.getDepth()).compareTo(otherProject.getDepth());
    }

    @Override
    public int compareTo(Project otherProject) {
        int depthCompare = this.depthCompare(otherProject);
        if (depthCompare == 0) {
            return this.getPath().compareTo(otherProject.getPath());
        }
        return depthCompare;
    }

    @Override
    public String absoluteProjectPath(String path) {
        return this.path.absolutePath(path);
    }

    @Override
    public String relativeProjectPath(String path) {
        return this.path.relativePath(path);
    }

    @Override
    public ProjectInternal project(String path) {
        ProjectInternal project = this.findProject(path);
        if (project == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found in %s.", path, this));
        }
        return project;
    }

    @Override
    public ProjectInternal findProject(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.projectRegistry.getProject(this.absoluteProjectPath(path));
    }

    @Override
    public Set<Project> getAllprojects() {
        return new TreeSet<Project>(this.projectRegistry.getAllProjects(this.getPath()));
    }

    @Override
    public Set<Project> getSubprojects() {
        return new TreeSet<Project>(this.projectRegistry.getSubProjects(this.getPath()));
    }

    @Override
    public void subprojects(Action<? super Project> action) {
        this.configure(this.getSubprojects(), action);
    }

    @Override
    public void allprojects(Action<? super Project> action) {
        this.configure(this.getAllprojects(), action);
    }

    @Override
    public <T> Iterable<T> configure(Iterable<T> objects, Action<? super T> configureAction) {
        for (T object : objects) {
            configureAction.execute(object);
        }
        return objects;
    }

    @Override
    public AntBuilder getAnt() {
        if (this.ant == null) {
            this.ant = this.createAntBuilder();
        }
        return this.ant;
    }

    @Override
    public AntBuilder createAntBuilder() {
        return (AntBuilder)((Object)this.antBuilderFactory.create());
    }

    @Override
    public Project getProject() {
        return this;
    }

    @Override
    public AbstractProject evaluate() {
        this.projectEvaluator.evaluate(this, this.state);
        this.state.rethrowFailure();
        return this;
    }

    @Override
    public TaskContainerInternal getTasks() {
        return this.taskContainer;
    }

    @Override
    public TaskContainerInternal getImplicitTasks() {
        return this.implicitTasksContainer;
    }

    @Override
    public void defaultTasks(String ... defaultTasks) {
        if (defaultTasks == null) {
            throw new InvalidUserDataException("Default tasks must not be null!");
        }
        this.defaultTasks = new ArrayList<String>();
        for (String defaultTask : defaultTasks) {
            if (defaultTask == null) {
                throw new InvalidUserDataException("Default tasks must not be null!");
            }
            this.defaultTasks.add(defaultTask);
        }
    }

    public Task createTask(Map args, String name, Closure action) {
        this.warnCreateTaskDeprecated();
        HashMap<String, String> allArgs = new HashMap<String, String>(args);
        allArgs.put("name", name);
        allArgs.put("action", (String)action);
        return this.taskContainer.create(allArgs);
    }

    public Task createTask(Map<String, ?> args, String name, Action<? super Task> action) {
        this.warnCreateTaskDeprecated();
        HashMap allArgs = new HashMap(args);
        allArgs.put("name", name);
        if (action != null) {
            allArgs.put("action", action);
        }
        return this.taskContainer.create(allArgs);
    }

    private void warnCreateTaskDeprecated() {
        DeprecationLogger.nagUserOfReplacedMethod("Project.createTask()", "task()");
    }

    @Override
    public void addChildProject(ProjectInternal childProject) {
        this.childProjects.put(childProject.getName(), childProject);
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public File getBuildDir() {
        return this.file(this.buildDir);
    }

    @Override
    public void setBuildDir(Object path) {
        this.buildDir = path;
    }

    @Override
    public void dependsOn(final String path) {
        DeprecationLogger.nagUserOfDiscontinuedMethod("Project.dependsOn(String path)");
        DeprecationLogger.whileDisabled(new Factory<Void>(){

            public Void create() {
                AbstractProject.this.dependsOn(path, true);
                return null;
            }
        });
    }

    @Override
    public void dependsOn(String path, boolean evaluateDependsOnProject) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        this.dependsOnProjects.add(this.project(path));
        if (evaluateDependsOnProject) {
            this.evaluationDependsOn(path);
        }
    }

    @Override
    public void evaluationDependsOnChildren() {
        for (Project project : this.childProjects.values()) {
            DefaultProject defaultProjectToEvaluate = (DefaultProject)project;
            this.evaluationDependsOn(defaultProjectToEvaluate);
        }
    }

    @Override
    public Project evaluationDependsOn(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        DefaultProject projectToEvaluate = (DefaultProject)this.project(path);
        return this.evaluationDependsOn(projectToEvaluate);
    }

    private Project evaluationDependsOn(DefaultProject projectToEvaluate) {
        if (projectToEvaluate.getState().getExecuting()) {
            throw new CircularReferenceException(String.format("Circular referencing during evaluation for %s.", projectToEvaluate));
        }
        return projectToEvaluate.evaluate();
    }

    @Override
    public Project childrenDependOnMe() {
        DeprecationLogger.nagUserOfDiscontinuedMethod("Project.childrenDependOnMe()");
        DeprecationLogger.whileDisabled(new Factory<Void>(){

            public Void create() {
                for (Project project : AbstractProject.this.childProjects.values()) {
                    project.dependsOn(AbstractProject.this.getPath(), false);
                }
                return null;
            }
        });
        return this;
    }

    @Override
    public Project dependsOnChildren() {
        DeprecationLogger.nagUserOfDiscontinuedMethod("Project.dependsOnChildren()");
        return DeprecationLogger.whileDisabled(new Factory<Project>(){

            public Project create() {
                return AbstractProject.this.dependsOnChildren(false);
            }
        });
    }

    @Override
    public Project dependsOnChildren(final boolean evaluateDependsOnProject) {
        DeprecationLogger.nagUserOfDiscontinuedMethod("Project.dependsOnChildren(boolean)");
        DeprecationLogger.whileDisabled(new Factory<Void>(){

            public Void create() {
                for (Project project : AbstractProject.this.childProjects.values()) {
                    AbstractProject.this.dependsOn(project.getPath(), evaluateDependsOnProject);
                }
                return null;
            }
        });
        return this;
    }

    public String toString() {
        if (this.parent != null) {
            return String.format("project '%s'", this.path);
        }
        return String.format("root project '%s'", this.name);
    }

    @Override
    public Map<Project, Set<Task>> getAllTasks(boolean recursive) {
        final TreeMap<Project, Set<Task>> foundTargets = new TreeMap<Project, Set<Task>>();
        Action<Project> action = new Action<Project>(){

            public void execute(Project project) {
                foundTargets.put(project, new TreeSet<Task>(project.getTasks()));
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute((Object)this);
        }
        return foundTargets;
    }

    @Override
    public Set<Task> getTasksByName(final String name, boolean recursive) {
        if (!GUtil.isTrue(name)) {
            throw new InvalidUserDataException("Name is not specified!");
        }
        final HashSet<Task> foundTasks = new HashSet<Task>();
        Action<Project> action = new Action<Project>(){

            public void execute(Project project) {
                Task task = (Task)project.getTasks().findByName(name);
                if (task != null) {
                    foundTasks.add(task);
                }
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute((Object)this);
        }
        return foundTasks;
    }

    @Override
    public File file(Object path) {
        return this.fileOperations.file(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.fileOperations.file(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.fileOperations.uri(path);
    }

    @Override
    public ConfigurableFileCollection files(Object ... paths) {
        return this.fileOperations.files(paths);
    }

    @Override
    public ConfigurableFileCollection files(Object paths, Closure closure) {
        return this.fileOperations.files(paths, closure);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        return this.fileOperations.fileTree(baseDir);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir, Closure closure) {
        return this.fileOperations.fileTree(baseDir, closure);
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return this.fileOperations.fileTree(args);
    }

    @Override
    public ConfigurableFileTree fileTree(Closure closure) {
        DeprecationLogger.nagUserOfDeprecated("fileTree(Closure)", "Use fileTree((Object){ baseDir }) to have the closure used as the file tree base directory");
        return this.fileOperations.fileTree(closure);
    }

    @Override
    public FileTree zipTree(Object zipPath) {
        return this.fileOperations.zipTree(zipPath);
    }

    @Override
    public FileTree tarTree(Object tarPath) {
        return this.fileOperations.tarTree(tarPath);
    }

    @Override
    public ResourceHandler getResources() {
        return this.fileOperations.getResources();
    }

    @Override
    public String relativePath(Object path) {
        return this.fileOperations.relativePath(path);
    }

    @Override
    public File mkdir(Object path) {
        return this.fileOperations.mkdir(path);
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.fileOperations.delete(paths);
    }

    @Deprecated
    public Directory dir(String path) {
        DeprecationLogger.nagUserOfReplacedMethod("AbstractProject.dir()", "mkdir()");
        String[] pathElements = path.split("/");
        String name = "";
        Directory dirTask = null;
        for (String pathElement : pathElements) {
            Task task = (Task)this.taskContainer.findByName(name = name + (name.length() != 0 ? "/" + pathElement : pathElement));
            if (task instanceof Directory) {
                dirTask = (Directory)task;
                continue;
            }
            if (task != null) {
                throw new InvalidUserDataException(String.format("Cannot add directory task '%s' as a non-directory task with this name already exists.", name));
            }
            dirTask = this.taskContainer.create(name, Directory.class);
        }
        return dirTask;
    }

    public void setTaskContainer(TaskContainerInternal taskContainer) {
        this.taskContainer = taskContainer;
    }

    public Factory<AntBuilder> getAntBuilderFactory() {
        return this.antBuilderFactory;
    }

    public void setAntBuilderFactory(Factory<AntBuilder> antBuilderFactory) {
        this.antBuilderFactory = antBuilderFactory;
    }

    @Override
    public DependencyHandler getDependencies() {
        return this.dependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return this.evaluationListener.getSource();
    }

    @Override
    public void beforeEvaluate(Action<? super Project> action) {
        this.evaluationListener.add("beforeEvaluate", action);
    }

    @Override
    public void afterEvaluate(Action<? super Project> action) {
        this.evaluationListener.add("afterEvaluate", action);
    }

    @Override
    public void beforeEvaluate(Closure closure) {
        this.evaluationListener.add(new ClosureBackedMethodInvocationDispatch("beforeEvaluate", closure));
    }

    @Override
    public void afterEvaluate(Closure closure) {
        this.evaluationListener.add(new ClosureBackedMethodInvocationDispatch("afterEvaluate", closure));
    }

    @Override
    public Logger getLogger() {
        return buildLogger;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.loggingManager;
    }

    @Override
    public LoggingManager getLogging() {
        return this.loggingManager;
    }

    @Override
    public SoftwareComponentContainer getComponents() {
        return this.softwareComponentContainer;
    }

    @Override
    public Object property(String propertyName) throws MissingPropertyException {
        return this.extensibleDynamicObject.getProperty(propertyName);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.extensibleDynamicObject.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.extensibleDynamicObject.hasProperty(propertyName);
    }

    @Override
    public Map<String, ?> getProperties() {
        return (Map)DeprecationLogger.whileDisabled(new Factory<Map<String, ?>>(){

            public Map<String, ?> create() {
                return AbstractProject.this.extensibleDynamicObject.getProperties();
            }
        });
    }

    @Override
    public WorkResult copy(Closure closure) {
        return this.fileOperations.copy(closure);
    }

    @Override
    public CopySpec copySpec(Closure closure) {
        return this.fileOperations.copySpec(closure);
    }

    @Override
    public ExecResult javaexec(Closure closure) {
        return this.processOperations.javaexec(closure);
    }

    @Override
    public ExecResult exec(Closure closure) {
        return this.processOperations.exec(closure);
    }

    @Override
    public ServiceRegistryFactory getServices() {
        return this.services;
    }

    @Override
    public Module getModule() {
        return ((DependencyMetaDataProvider)this.getServices().get(DependencyMetaDataProvider.class)).getModule();
    }

    @Override
    public AntBuilder ant(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getAnt());
    }

    @Override
    public void subprojects(Closure configureClosure) {
        this.configure(this.getSubprojects(), configureClosure);
    }

    @Override
    public void allprojects(Closure configureClosure) {
        this.configure(this.getAllprojects(), configureClosure);
    }

    @Override
    public Project project(String path, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.project(path));
    }

    @Override
    public Object configure(Object object, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, object);
    }

    @Override
    public Iterable<?> configure(Iterable<?> objects, Closure configureClosure) {
        for (Object object : objects) {
            this.configure(object, configureClosure);
        }
        return objects;
    }

    @Override
    public void configurations(Closure configureClosure) {
        this.getConfigurations().configure(configureClosure);
    }

    @Override
    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getRepositories());
    }

    @Override
    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getDependencies());
    }

    @Override
    public void artifacts(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getArtifacts());
    }

    @Override
    public void buildscript(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getBuildscript());
    }

    @Override
    public Task task(String task) {
        return this.taskContainer.create(task);
    }

    public Task task(Object task) {
        return this.taskContainer.create(task.toString());
    }

    @Override
    public Task task(String task, Closure configureClosure) {
        return this.taskContainer.create(task).configure(configureClosure);
    }

    public Task task(Object task, Closure configureClosure) {
        return this.task(task.toString(), configureClosure);
    }

    public Task task(Map options, String task) {
        return this.taskContainer.create(GUtil.addMaps(options, Collections.singletonMap("name", task)));
    }

    public Task task(Map options, Object task) {
        return this.task(options, task.toString());
    }

    public Task task(Map options, String task, Closure configureClosure) {
        return this.taskContainer.create(GUtil.addMaps(options, Collections.singletonMap("name", task))).configure(configureClosure);
    }

    public Task task(Map options, Object task, Closure configureClosure) {
        return this.task(options, task.toString(), configureClosure);
    }

    @Override
    protected ScriptPluginFactory getScriptPluginFactory() {
        return this.scriptPluginFactory;
    }

    public Object passThrough(Object object) {
        return object;
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return (NamedDomainObjectContainer)instantiator.newInstance(FactoryNamedDomainObjectContainer.class, new Object[]{type, instantiator, new DynamicPropertyNamer()});
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, NamedDomainObjectFactory<T> factory) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return (NamedDomainObjectContainer)instantiator.newInstance(FactoryNamedDomainObjectContainer.class, new Object[]{type, instantiator, new DynamicPropertyNamer(), factory});
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, Closure factoryClosure) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return (NamedDomainObjectContainer)instantiator.newInstance(FactoryNamedDomainObjectContainer.class, new Object[]{type, instantiator, new DynamicPropertyNamer(), factoryClosure});
    }

    @Override
    public ExtensionContainerInternal getExtensions() {
        return (ExtensionContainerInternal)((Object)this.getConvention());
    }
}

