/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.cache.PersistentIndexedCache;

public class CacheBackedFileSnapshotRepository
implements FileSnapshotRepository {
    private final PersistentIndexedCache<Object, Object> cache;

    public CacheBackedFileSnapshotRepository(TaskArtifactStateCacheAccess cacheAccess) {
        this.cache = cacheAccess.createCache("fileSnapshots", Object.class, Object.class);
    }

    public Long add(FileCollectionSnapshot snapshot) {
        Long id = (Long)this.cache.get("nextId");
        if (id == null) {
            id = 1L;
        }
        this.cache.put("nextId", id + 1L);
        this.cache.put(id, snapshot);
        return id;
    }

    public FileCollectionSnapshot get(Long id) {
        return (FileCollectionSnapshot)this.cache.get(id);
    }

    public void remove(Long id) {
        this.cache.remove(id);
    }
}

