/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.CachingTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputFilesStateChangeRule;
import org.gradle.api.internal.changedetection.rules.InputPropertiesStateChangeRule;
import org.gradle.api.internal.changedetection.rules.NoHistoryStateChangeRule;
import org.gradle.api.internal.changedetection.rules.OutputFilesStateChangeRule;
import org.gradle.api.internal.changedetection.rules.SummaryTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskTypeStateChangeRule;
import org.gradle.api.internal.changedetection.rules.TaskUpToDateSpecStateChangeRule;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;

public class TaskUpToDateState {
    private static final int MAX_OUT_OF_DATE_MESSAGES = 10;
    private TaskStateChanges upToDateSpecState;
    private TaskStateChanges noHistoryState;
    private TaskStateChanges inputFilesState;
    private TaskStateChanges inputPropertiesState;
    private TaskStateChanges taskTypeState;
    private TaskStateChanges outputFilesState;
    private SummaryTaskStateChanges allTaskChanges;
    private SummaryTaskStateChanges rebuildChanges;

    public TaskUpToDateState(TaskInternal task, TaskHistoryRepository.History history, FileSnapshotter outputFilesSnapshotter, FileSnapshotter inputFilesSnapshotter) {
        TaskExecution thisExecution = history.getCurrentExecution();
        TaskExecution lastExecution = history.getPreviousExecution();
        this.upToDateSpecState = TaskUpToDateSpecStateChangeRule.create(task);
        this.noHistoryState = NoHistoryStateChangeRule.create(task, lastExecution);
        this.taskTypeState = TaskTypeStateChangeRule.create(task, lastExecution, thisExecution);
        this.inputPropertiesState = InputPropertiesStateChangeRule.create(task, lastExecution, thisExecution);
        this.outputFilesState = this.caching(OutputFilesStateChangeRule.create(task, lastExecution, thisExecution, outputFilesSnapshotter));
        this.inputFilesState = this.caching(InputFilesStateChangeRule.create(task, lastExecution, thisExecution, inputFilesSnapshotter));
        this.allTaskChanges = new SummaryTaskStateChanges(10, this.upToDateSpecState, this.noHistoryState, this.taskTypeState, this.inputPropertiesState, this.outputFilesState, this.inputFilesState);
        this.rebuildChanges = new SummaryTaskStateChanges(1, this.upToDateSpecState, this.noHistoryState, this.taskTypeState, this.inputPropertiesState, this.outputFilesState);
    }

    private TaskStateChanges caching(TaskStateChanges wrapped) {
        return new CachingTaskStateChanges(10, wrapped);
    }

    public TaskStateChanges getInputFilesChanges() {
        return this.inputFilesState;
    }

    public TaskStateChanges getAllTaskChanges() {
        return this.allTaskChanges;
    }

    public TaskStateChanges getRebuildChanges() {
        return this.rebuildChanges;
    }
}

