/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.SimpleTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.TaskExecution;

class TaskTypeStateChangeRule {
    TaskTypeStateChangeRule() {
    }

    public static TaskStateChanges create(final TaskInternal task, final TaskExecution previousExecution, TaskExecution currentExecution) {
        final String taskClass = task.getClass().getName();
        currentExecution.setTaskClass(taskClass);
        return new SimpleTaskStateChanges(){

            @Override
            protected void addAllChanges(List<TaskStateChange> changes) {
                if (!taskClass.equals(previousExecution.getTaskClass())) {
                    changes.add(new DescriptiveChange("%s has changed type from '%s' to '%s'.", StringUtils.capitalize((String)task.toString()), previousExecution.getTaskClass(), task.getClass().getName()));
                }
            }

            @Override
            public void snapshotAfterTask() {
            }
        };
    }
}

