/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.SimpleTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;

class InputPropertiesStateChangeRule {
    InputPropertiesStateChangeRule() {
    }

    public static TaskStateChanges create(final TaskInternal task, final TaskExecution previousExecution, TaskExecution currentExecution) {
        final HashMap<String, Object> properties = new HashMap<String, Object>(task.getInputs().getProperties());
        currentExecution.setInputProperties(properties);
        return new SimpleTaskStateChanges(){

            @Override
            protected void addAllChanges(final List<TaskStateChange> changes) {
                DiffUtil.diff(properties, previousExecution.getInputProperties(), new ChangeListener<Map.Entry<String, Object>>(){

                    @Override
                    public void added(Map.Entry<String, Object> element) {
                        changes.add(new DescriptiveChange("Input property '%s' has been added for %s", element.getKey(), task));
                    }

                    @Override
                    public void removed(Map.Entry<String, Object> element) {
                        changes.add(new DescriptiveChange("Input property '%s' has been removed for %s", element.getKey(), task));
                    }

                    @Override
                    public void changed(Map.Entry<String, Object> element) {
                        changes.add(new DescriptiveChange("Value of input property '%s' has changed for %s", element.getKey(), task));
                    }
                });
            }

            @Override
            public void snapshotAfterTask() {
            }
        };
    }
}

