/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import org.apache.commons.lang.StringUtils;
import org.gradle.StartParameter;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.NoHistoryArtifactState;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.reflect.Instantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortCircuitTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortCircuitTaskArtifactStateRepository.class);
    private final StartParameter startParameter;
    private final TaskArtifactStateRepository repository;
    private final Instantiator instantiator;

    public ShortCircuitTaskArtifactStateRepository(StartParameter startParameter, Instantiator instantiator, TaskArtifactStateRepository repository) {
        this.startParameter = startParameter;
        this.instantiator = instantiator;
        this.repository = repository;
    }

    public TaskArtifactState getStateFor(TaskInternal task) {
        if (!task.getOutputs().getHasOutput()) {
            LOGGER.info(String.format("%s has not declared any outputs, assuming that it is out-of-date.", StringUtils.capitalize((String)task.toString())));
            return new NoHistoryArtifactState();
        }
        TaskArtifactState state = this.repository.getStateFor(task);
        if (this.startParameter.isRerunTasks()) {
            LOGGER.info(String.format("Executing %s with '--rerun-tasks', assuming that it is out-of-date.", StringUtils.capitalize((String)task.toString())));
            return new RerunTaskArtifactState(state, task);
        }
        return state;
    }

    private class RerunTaskArtifactState
    implements TaskArtifactState {
        private final TaskArtifactState delegate;
        private final TaskInternal task;

        private RerunTaskArtifactState(TaskArtifactState delegate, TaskInternal task) {
            this.delegate = delegate;
            this.task = task;
        }

        public boolean isUpToDate() {
            return false;
        }

        public IncrementalTaskInputs getInputChanges() {
            return (IncrementalTaskInputs)ShortCircuitTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{this.task});
        }

        public TaskExecutionHistory getExecutionHistory() {
            return this.delegate.getExecutionHistory();
        }

        public void beforeTask() {
            this.delegate.beforeTask();
        }

        public void afterTask() {
            this.delegate.afterTask();
        }

        public void finished() {
            this.delegate.finished();
        }
    }
}

